/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;

public interface PsiElementProcessor<T extends PsiElement> {
    public boolean execute(T var1);

    public static class FindFilteredElement<T extends PsiElement>
    extends FindElement<T> {
        private final PsiElementFilter myFilter;

        public FindFilteredElement(PsiElementFilter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean execute(T element) {
            return !this.myFilter.isAccepted((PsiElement)element) || super.execute(element);
        }
    }

    public static class FindElement<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private volatile T myFoundElement = null;

        public boolean isFound() {
            return this.myFoundElement != null;
        }

        public T getFoundElement() {
            return this.myFoundElement;
        }

        public boolean setFound(T element) {
            this.myFoundElement = element;
            return false;
        }

        @Override
        public boolean execute(T element) {
            return this.setFound(element);
        }
    }

    public static class CollectElementsWithLimit<T extends PsiElement>
    extends CollectElements<T> {
        private final AtomicInteger myCount = new AtomicInteger(0);
        private volatile boolean myOverflow = false;
        private final int myLimit;

        public CollectElementsWithLimit(int limit) {
            this.myLimit = limit;
        }

        public CollectElementsWithLimit(int limit, Collection<T> collection) {
            super(collection);
            this.myLimit = limit;
        }

        @Override
        public boolean execute(T element) {
            if (this.myCount.get() == this.myLimit) {
                this.myOverflow = true;
                return false;
            }
            this.myCount.incrementAndGet();
            return super.execute(element);
        }

        public boolean isOverflow() {
            return this.myOverflow;
        }
    }

    public static class CollectFilteredElements<T extends PsiElement>
    extends CollectElements<T> {
        private final PsiElementFilter myFilter;

        public CollectFilteredElements(PsiElementFilter filter, Collection<T> collection) {
            super(collection);
            this.myFilter = filter;
        }

        public CollectFilteredElements(PsiElementFilter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean execute(T element) {
            return !this.myFilter.isAccepted((PsiElement)element) || super.execute(element);
        }
    }

    public static class CollectElements<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private final Collection<T> myCollection;

        public CollectElements() {
            this(new ArrayList());
        }

        public CollectElements(Collection<T> collection) {
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        public PsiElement[] toArray() {
            return PsiUtilCore.toPsiElementArray(this.myCollection);
        }

        public Collection<T> getCollection() {
            return this.myCollection;
        }

        public T[] toArray(T[] array) {
            return (PsiElement[])this.myCollection.toArray(array);
        }

        @Override
        public boolean execute(T element) {
            this.myCollection.add(element);
            return true;
        }
    }
}

