/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.GlobalSearchScope");
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    public abstract boolean contains(VirtualFile var1);

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public abstract int compare(VirtualFile var1, VirtualFile var2);

    public abstract boolean isSearchInModuleContent(Module var1);

    public boolean isSearchInModuleContent(Module aModule, boolean testSources) {
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(VirtualFile file) {
        return this.contains(file);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    public boolean isSearchOutsideRootModel() {
        return false;
    }

    public GlobalSearchScope intersectWith(GlobalSearchScope scope) {
        if (scope == this) {
            return this;
        }
        if (scope instanceof IntersectionScope) {
            return scope.intersectWith(this);
        }
        return new IntersectionScope(this, scope, null);
    }

    @Override
    public SearchScope intersectWith(SearchScope scope2) {
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localScope2 = (LocalSearchScope)scope2;
            return this.intersectWith(localScope2);
        }
        return this.intersectWith((GlobalSearchScope)scope2);
    }

    public SearchScope intersectWith(LocalSearchScope localScope2) {
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result.add(element2);
        }
        return result.isEmpty() ? EMPTY_SCOPE : new LocalSearchScope(result.toArray(new PsiElement[result.size()]), null, localScope2.isIgnoreInjectedPsi());
    }

    @Override
    public GlobalSearchScope union(SearchScope scope) {
        if (scope instanceof GlobalSearchScope) {
            return this.uniteWith((GlobalSearchScope)scope);
        }
        return this.union((LocalSearchScope)scope);
    }

    public GlobalSearchScope union(final LocalSearchScope scope) {
        return new GlobalSearchScope(scope.getScope()[0].getProject()){

            @Override
            public boolean contains(VirtualFile file) {
                return GlobalSearchScope.this.contains(file) || scope.isInScope(file);
            }

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(Module aModule) {
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchOutsideRootModel() {
                return GlobalSearchScope.this.isSearchOutsideRootModel();
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this.toString() + ", " + scope + ")";
            }
        };
    }

    public GlobalSearchScope uniteWith(GlobalSearchScope scope) {
        if (scope == this) {
            return scope;
        }
        return new UnionScope(this, scope);
    }

    public static GlobalSearchScope union(GlobalSearchScope[] scopes) {
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            return scopes[0];
        }
        return new UnionScope(scopes);
    }

    public static GlobalSearchScope allScope(Project project) {
        return ProjectScope.getAllScope(project);
    }

    public static GlobalSearchScope projectScope(Project project) {
        return ProjectScope.getProjectScope(project);
    }

    public static GlobalSearchScope notScope(GlobalSearchScope scope) {
        return new NotScope(scope);
    }

    public static GlobalSearchScope moduleScope(Module module) {
        return module.getModuleScope();
    }

    public static GlobalSearchScope moduleWithLibrariesScope(Module module) {
        return module.getModuleWithLibrariesScope();
    }

    public static GlobalSearchScope moduleWithDependenciesScope(Module module) {
        return module.getModuleWithDependenciesScope();
    }

    public static GlobalSearchScope moduleRuntimeScope(Module module, boolean includeTests) {
        return module.getModuleRuntimeScope(includeTests);
    }

    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(Module module) {
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, true);
    }

    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(Module module, boolean includeTests) {
        return module.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    public static GlobalSearchScope moduleWithDependentsScope(Module module) {
        return module.getModuleWithDependentsScope();
    }

    public static GlobalSearchScope moduleTestsWithDependentsScope(Module module) {
        return module.getModuleTestsWithDependentsScope();
    }

    public static GlobalSearchScope fileScope(PsiFile psiFile) {
        return new FileScope(psiFile.getProject(), psiFile.getVirtualFile());
    }

    public static GlobalSearchScope fileScope(Project project, VirtualFile virtualFile) {
        return GlobalSearchScope.fileScope(project, virtualFile, null);
    }

    public static GlobalSearchScope fileScope(Project project, VirtualFile virtualFile, final String displayName) {
        return new FileScope(project, virtualFile){

            @Override
            public String getDisplayName() {
                return displayName == null ? super.getDisplayName() : displayName;
            }
        };
    }

    public static GlobalSearchScope filesScope(Project project, Collection<VirtualFile> files) {
        return GlobalSearchScope.filesScope(project, files, null);
    }

    public static GlobalSearchScope filesScope(Project project, Collection<VirtualFile> files, final String displayName) {
        if (files.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return files.size() == 1 ? GlobalSearchScope.fileScope(project, files.iterator().next(), displayName) : new FilesScope(project, files){

            @Override
            public String getDisplayName() {
                return displayName == null ? super.getDisplayName() : displayName;
            }
        };
    }

    public static GlobalSearchScope getScopeRestrictedByFileTypes(GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == EMPTY_SCOPE) {
            return EMPTY_SCOPE;
        }
        LOG.assertTrue(fileTypes.length > 0);
        return new FileTypeRestrictionScope(scope, fileTypes);
    }

    public static class FilesScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final Collection<VirtualFile> myFiles;

        public FilesScope(Project project, Collection<VirtualFile> files) {
            super(project);
            this.myFiles = files;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myFiles.contains(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof FilesScope && ((Object)this.myFiles).equals(((FilesScope)o).myFiles);
        }

        @Override
        public int hashCode() {
            return ((Object)this.myFiles).hashCode();
        }

        public String toString() {
            ArrayList<VirtualFile> files = this.myFiles.size() <= 20 ? new ArrayList<VirtualFile>(this.myFiles) : new ArrayList<VirtualFile>(this.myFiles).subList(0, 20);
            return "Files: (" + files + ")";
        }

        @Override
        public Iterator<VirtualFile> iterator() {
            return this.myFiles.iterator();
        }
    }

    private static class FileScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final VirtualFile myVirtualFile;
        private final Module myModule;

        private FileScope(Project project, VirtualFile virtualFile) {
            super(project);
            this.myVirtualFile = virtualFile;
            this.myModule = virtualFile == null || project.isDefault() ? null : FileIndexFacade.getInstance(project).getModuleForFile(virtualFile);
        }

        @Override
        public boolean contains(VirtualFile file) {
            return Comparing.equal((Object)this.myVirtualFile, (Object)file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(Module aModule) {
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }

        public String toString() {
            return "File :" + this.myVirtualFile;
        }

        @Override
        public Iterator<VirtualFile> iterator() {
            return Collections.singletonList(this.myVirtualFile).iterator();
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(VirtualFile file) {
            return false;
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(Module aModule) {
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        public GlobalSearchScope intersectWith(GlobalSearchScope scope) {
            return this;
        }

        @Override
        public GlobalSearchScope uniteWith(GlobalSearchScope scope) {
            return scope;
        }

        public String toString() {
            return "EMPTY";
        }
    }

    private static class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(GlobalSearchScope scope, FileType[] fileTypes) {
            super(scope);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(VirtualFile file) {
            if (!super.contains(file)) {
                return false;
            }
            FileType fileType = file.getFileType();
            for (FileType otherFileType : this.myFileTypes) {
                if (!fileType.equals(otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public GlobalSearchScope intersectWith(GlobalSearchScope scope) {
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    return new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(new FileType[intersection.size()]));
                }
            }
            return super.intersectWith(scope);
        }

        @Override
        public GlobalSearchScope uniteWith(GlobalSearchScope scope) {
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    return new FileTypeRestrictionScope(this.myBaseScope, (FileType[])ArrayUtil.mergeArrays((Object[])this.myFileTypes, (Object[])restrict.myFileTypes));
                }
            }
            return super.uniteWith(scope);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.myFileTypes);
            return result;
        }

        public String toString() {
            return "(" + this.myBaseScope + " restricted by file types: " + Arrays.asList(this.myFileTypes) + ")";
        }
    }

    private static class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope[] myScopes;
        private final int myNestingLevel;

        private UnionScope(GlobalSearchScope scope1, GlobalSearchScope scope2) {
            this(new GlobalSearchScope[]{scope1, scope2});
        }

        private UnionScope(GlobalSearchScope[] scopes) {
            super((Project)ContainerUtil.getFirstItem((Collection)ContainerUtil.mapNotNull((Object[])scopes, (Function)new Function<GlobalSearchScope, Project>(){

                public Project fun(GlobalSearchScope scope) {
                    return scope.getProject();
                }
            }), null));
            assert (scopes.length > 1) : Arrays.asList(scopes);
            this.myScopes = scopes;
            final int[] nested = new int[]{0};
            ContainerUtil.process((Object[])scopes, (Processor)new Processor<GlobalSearchScope>(){

                public boolean process(GlobalSearchScope scope) {
                    nested[0] = Math.max(nested[0], scope instanceof UnionScope ? ((UnionScope)scope).myNestingLevel : 0);
                    return true;
                }
            });
            this.myNestingLevel = 1 + nested[0];
            if (this.myNestingLevel > 1000) {
                throw new IllegalStateException("Too many scopes combined: " + this.myNestingLevel + StringUtil.first((String)this.toString(), (int)500, (boolean)true));
            }
        }

        @Override
        public String getDisplayName() {
            return PsiBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
        }

        @Override
        public boolean contains(final VirtualFile file) {
            return ContainerUtil.find((Object[])this.myScopes, (Condition)new Condition<GlobalSearchScope>(){

                public boolean value(GlobalSearchScope scope) {
                    return scope.contains(file);
                }
            }) != null;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return ContainerUtil.find((Object[])this.myScopes, (Condition)new Condition<GlobalSearchScope>(){

                public boolean value(GlobalSearchScope scope) {
                    return scope.isSearchOutsideRootModel();
                }
            }) != null;
        }

        @Override
        public int compare(final VirtualFile file1, final VirtualFile file2) {
            final int[] result = new int[]{0};
            ContainerUtil.process((Object[])this.myScopes, (Processor)new Processor<GlobalSearchScope>(){

                public boolean process(GlobalSearchScope scope) {
                    int res1;
                    int n = res1 = scope.contains(file1) && scope.contains(file2) ? scope.compare(file1, file2) : 0;
                    if (result[0] == 0) {
                        result[0] = res1;
                        return true;
                    }
                    if (result[0] > 0 != res1 > 0) {
                        result[0] = 0;
                        return false;
                    }
                    return true;
                }
            });
            return result[0];
        }

        @Override
        public boolean isSearchInModuleContent(final Module module) {
            return ContainerUtil.find((Object[])this.myScopes, (Condition)new Condition<GlobalSearchScope>(){

                public boolean value(GlobalSearchScope scope) {
                    return scope.isSearchInModuleContent(module);
                }
            }) != null;
        }

        @Override
        public boolean isSearchInModuleContent(final Module module, final boolean testSources) {
            return ContainerUtil.find((Object[])this.myScopes, (Condition)new Condition<GlobalSearchScope>(){

                public boolean value(GlobalSearchScope scope) {
                    return scope.isSearchInModuleContent(module, testSources);
                }
            }) != null;
        }

        @Override
        public boolean isSearchInLibraries() {
            return ContainerUtil.find((Object[])this.myScopes, (Condition)new Condition<GlobalSearchScope>(){

                public boolean value(GlobalSearchScope scope) {
                    return scope.isSearchInLibraries();
                }
            }) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o;
            return new HashSet<GlobalSearchScope>(Arrays.asList(this.myScopes)).equals(new HashSet<GlobalSearchScope>(Arrays.asList(that.myScopes)));
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.myScopes);
        }

        public String toString() {
            return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), (String)",") + ")";
        }

        @Override
        public GlobalSearchScope uniteWith(GlobalSearchScope scope) {
            if (scope instanceof UnionScope) {
                GlobalSearchScope[] newScopes = (GlobalSearchScope[])ArrayUtil.mergeArrays((Object[])this.myScopes, (Object[])((UnionScope)scope).myScopes);
                return new UnionScope(newScopes);
            }
            return super.uniteWith(scope);
        }
    }

    private static class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        private IntersectionScope(GlobalSearchScope scope1, GlobalSearchScope scope2, String displayName) {
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        @Override
        public GlobalSearchScope intersectWith(GlobalSearchScope scope) {
            if (this.myScope1.equals(scope) || this.myScope2.equals(scope)) {
                return this;
            }
            return new IntersectionScope(this, scope, null);
        }

        @Override
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                return PsiBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            }
            return this.myDisplayName;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myScope1.contains(file) && this.myScope2.contains(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(Module aModule) {
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(Module aModule, boolean testSources) {
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.myScope1.isSearchOutsideRootModel() && this.myScope2.isSearchOutsideRootModel();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int hashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }
    }

    private static class NotScope
    extends DelegatingGlobalSearchScope {
        private NotScope(GlobalSearchScope scope) {
            super(scope);
        }

        @Override
        public boolean contains(VirtualFile file) {
            return !this.myBaseScope.contains(file);
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(Module aModule, boolean testSources) {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return true;
        }

        public String toString() {
            return "NOT: " + this.myBaseScope;
        }
    }
}

