/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StdArrangementSettings
implements ArrangementSettings {
    private final List<ArrangementSectionRule> mySectionRules = new ArrayList<ArrangementSectionRule>();
    private final List<ArrangementGroupingRule> myGroupings = new ArrayList<ArrangementGroupingRule>();
    protected final List<StdArrangementMatchRule> myRulesByPriority = Collections.synchronizedList(new ArrayList());

    public StdArrangementSettings() {
    }

    public StdArrangementSettings(List<ArrangementSectionRule> rules) {
        this(Collections.EMPTY_LIST, rules);
    }

    public StdArrangementSettings(List<ArrangementGroupingRule> groupingRules, List<ArrangementSectionRule> sectionRules) {
        this.myGroupings.addAll(groupingRules);
        this.mySectionRules.addAll(sectionRules);
    }

    public static StdArrangementSettings createByMatchRules(List<ArrangementGroupingRule> groupingRules, List<StdArrangementMatchRule> matchRules) {
        ArrayList<ArrangementSectionRule> sectionRules = new ArrayList<ArrangementSectionRule>();
        for (StdArrangementMatchRule rule : matchRules) {
            sectionRules.add(ArrangementSectionRule.create(rule));
        }
        return new StdArrangementSettings(groupingRules, sectionRules);
    }

    protected List<ArrangementGroupingRule> cloneGroupings() {
        ArrayList<ArrangementGroupingRule> groupings = new ArrayList<ArrangementGroupingRule>();
        for (ArrangementGroupingRule grouping : this.myGroupings) {
            groupings.add(grouping.clone());
        }
        return groupings;
    }

    protected List<ArrangementSectionRule> cloneSectionRules() {
        ArrayList<ArrangementSectionRule> rules = new ArrayList<ArrangementSectionRule>();
        for (ArrangementSectionRule rule : this.mySectionRules) {
            rules.add(rule.clone());
        }
        return rules;
    }

    @Override
    public ArrangementSettings clone() {
        return new StdArrangementSettings(this.cloneGroupings(), this.cloneSectionRules());
    }

    @Override
    public List<ArrangementGroupingRule> getGroupings() {
        return this.myGroupings;
    }

    @Override
    public List<ArrangementSectionRule> getSections() {
        return this.mySectionRules;
    }

    public List<StdArrangementMatchRule> getRules() {
        return ArrangementUtil.collectMatchRules(this.mySectionRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends ArrangementMatchRule> getRulesSortedByPriority() {
        List<StdArrangementMatchRule> list = this.myRulesByPriority;
        synchronized (list) {
            if (this.myRulesByPriority.isEmpty()) {
                for (ArrangementSectionRule rule : this.mySectionRules) {
                    this.myRulesByPriority.addAll(rule.getMatchRules());
                }
                ContainerUtil.sort(this.myRulesByPriority);
            }
        }
        return this.myRulesByPriority;
    }

    public void addRule(StdArrangementMatchRule rule) {
        this.addSectionRule(rule);
        this.myRulesByPriority.clear();
    }

    public void addSectionRule(StdArrangementMatchRule rule) {
        this.mySectionRules.add(ArrangementSectionRule.create(rule));
    }

    public void addGrouping(ArrangementGroupingRule rule) {
        this.myGroupings.add(rule);
    }

    public int hashCode() {
        int result = ((Object)this.mySectionRules).hashCode();
        result = 31 * result + ((Object)this.myGroupings).hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementSettings settings = (StdArrangementSettings)o;
        if (!((Object)this.myGroupings).equals(settings.myGroupings)) {
            return false;
        }
        return ((Object)this.mySectionRules).equals(settings.mySectionRules);
    }
}

