/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.InvertibleArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArrangementStandardSettingsManager {
    private final TObjectIntHashMap<ArrangementSettingsToken> myWidths = new TObjectIntHashMap();
    private final TObjectIntHashMap<ArrangementSettingsToken> myWeights = new TObjectIntHashMap();
    private final Comparator<ArrangementSettingsToken> myComparator = new Comparator<ArrangementSettingsToken>(){

        @Override
        public int compare(ArrangementSettingsToken t1, ArrangementSettingsToken t2) {
            if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t1)) {
                if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t2)) {
                    return ArrangementStandardSettingsManager.this.myWeights.get((Object)t1) - ArrangementStandardSettingsManager.this.myWeights.get((Object)t2);
                }
                return -1;
            }
            if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t2)) {
                return 1;
            }
            return t1.compareTo(t2);
        }
    };
    private final ArrangementStandardSettingsAware myDelegate;
    private final ArrangementColorsProvider myColorsProvider;
    private final Collection<Set<ArrangementSettingsToken>> myMutexes;
    private final StdArrangementSettings myDefaultSettings;
    private final List<CompositeArrangementSettingsToken> myGroupingTokens;
    private final List<CompositeArrangementSettingsToken> myMatchingTokens;
    private Collection<StdArrangementRuleAliasToken> myRuleAliases;
    private Set<ArrangementSettingsToken> myRuleAliasMutex;
    private CompositeArrangementSettingsToken myRuleAliasToken;

    public ArrangementStandardSettingsManager(ArrangementStandardSettingsAware delegate, ArrangementColorsProvider colorsProvider) {
        this(delegate, colorsProvider, ContainerUtil.emptyList());
    }

    public ArrangementStandardSettingsManager(ArrangementStandardSettingsAware delegate, ArrangementColorsProvider colorsProvider, Collection<StdArrangementRuleAliasToken> aliases) {
        this.myDelegate = delegate;
        this.myColorsProvider = colorsProvider;
        this.myMutexes = delegate.getMutexes();
        this.myDefaultSettings = delegate.getDefaultSettings();
        SimpleColoredComponent renderer = new SimpleColoredComponent();
        this.myGroupingTokens = delegate.getSupportedGroupingTokens();
        if (this.myGroupingTokens != null) {
            this.parseWidths(this.myGroupingTokens, renderer);
            this.buildWeights(this.myGroupingTokens);
        }
        this.myMatchingTokens = delegate.getSupportedMatchingTokens();
        if (this.myMatchingTokens != null) {
            this.parseWidths(this.myMatchingTokens, renderer);
            this.buildWeights(this.myMatchingTokens);
        }
        HashSet aliasTokens = ContainerUtil.newHashSet();
        aliasTokens.addAll(aliases);
        this.myRuleAliases = aliases;
        this.myRuleAliasMutex = aliasTokens;
        if (!this.myRuleAliases.isEmpty()) {
            this.myRuleAliasToken = new CompositeArrangementSettingsToken(StdArrangementTokens.General.ALIAS, aliasTokens);
        }
    }

    public Collection<StdArrangementRuleAliasToken> getRuleAliases() {
        return this.myRuleAliases;
    }

    public ArrangementStandardSettingsAware getDelegate() {
        return this.myDelegate;
    }

    private void parseWidths(Collection<CompositeArrangementSettingsToken> compositeTokens, SimpleColoredComponent renderer) {
        int width = 0;
        for (CompositeArrangementSettingsToken compositeToken : compositeTokens) {
            width = Math.max(width, this.parseWidth(compositeToken.getToken(), renderer));
        }
        for (CompositeArrangementSettingsToken compositeToken : compositeTokens) {
            this.myWidths.put((Object)compositeToken.getToken(), width);
            this.parseWidths(compositeToken.getChildren(), renderer);
        }
    }

    private void buildWeights(Collection<CompositeArrangementSettingsToken> compositeTokens) {
        for (CompositeArrangementSettingsToken token : compositeTokens) {
            this.myWeights.put((Object)token.getToken(), this.myWeights.size());
            this.buildWeights(token.getChildren());
        }
    }

    public StdArrangementSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    public boolean isSectionRulesSupported() {
        return this.myDelegate instanceof ArrangementSectionRuleAwareSettings;
    }

    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return this.myGroupingTokens;
    }

    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        if (this.myMatchingTokens == null || this.myRuleAliasToken == null) {
            return this.myMatchingTokens;
        }
        ArrayList allTokens = ContainerUtil.newArrayList(this.myMatchingTokens);
        allTokens.add(this.myRuleAliasToken);
        return allTokens;
    }

    public boolean isEnabled(ArrangementSettingsToken token, ArrangementMatchCondition current) {
        if (this.myRuleAliasMutex.contains(token)) {
            return true;
        }
        return this.myDelegate.isEnabled(token, current);
    }

    public ArrangementEntryMatcher buildMatcher(ArrangementMatchCondition condition) throws IllegalArgumentException {
        ArrangementEntryMatcher matcher = ArrangementUtil.buildMatcher(condition);
        if (matcher == null) {
            matcher = this.myDelegate.buildMatcher(condition);
        }
        return matcher;
    }

    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        if (this.myRuleAliasMutex.isEmpty()) {
            return this.myMutexes;
        }
        ArrayList allMutexes = ContainerUtil.newArrayList(this.myMutexes);
        allMutexes.add(this.myRuleAliasMutex);
        return allMutexes;
    }

    public int getWidth(ArrangementSettingsToken token) {
        if (this.myWidths.containsKey((Object)token)) {
            return this.myWidths.get((Object)token);
        }
        return this.parseWidth(token, new SimpleColoredComponent());
    }

    private int parseWidth(ArrangementSettingsToken token, SimpleColoredComponent renderer) {
        renderer.clear();
        String value = ArrangementStandardSettingsManager.getPresentationValue(token);
        renderer.append(value, SimpleTextAttributes.fromTextAttributes(this.myColorsProvider.getTextAttributes(token, true)));
        int result = renderer.getPreferredSize().width;
        renderer.clear();
        renderer.append(value, SimpleTextAttributes.fromTextAttributes(this.myColorsProvider.getTextAttributes(token, false)));
        return Math.max(result, renderer.getPreferredSize().width);
    }

    private static String getPresentationValue(ArrangementSettingsToken token) {
        if (token instanceof InvertibleArrangementSettingsToken) {
            return ((InvertibleArrangementSettingsToken)((Object)token)).getInvertedRepresentationValue();
        }
        return token.getRepresentationValue();
    }

    public List<ArrangementSettingsToken> sort(Collection<ArrangementSettingsToken> tokens) {
        ArrayList result = ContainerUtilRt.newArrayList(tokens);
        Collections.sort(result, this.myComparator);
        return result;
    }
}

