/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.model;

import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.InvertibleArrangementSettingsToken;

public class ArrangementAtomMatchCondition
implements ArrangementMatchCondition {
    private final ArrangementSettingsToken myType;
    private final Object myValue;

    public ArrangementAtomMatchCondition(ArrangementSettingsToken type) {
        this(type, type instanceof InvertibleArrangementSettingsToken ? Boolean.TRUE : type);
    }

    public ArrangementAtomMatchCondition(ArrangementSettingsToken type, Object value) {
        this.myType = type;
        this.myValue = value;
    }

    public ArrangementSettingsToken getType() {
        return this.myType;
    }

    public Object getValue() {
        return this.myValue;
    }

    @Override
    public void invite(ArrangementMatchConditionVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int result = this.myType.hashCode();
        result = 31 * result + this.myValue.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementAtomMatchCondition setting = (ArrangementAtomMatchCondition)o;
        if (!this.myType.equals(setting.myType)) {
            return false;
        }
        return this.myValue.equals(setting.myValue);
    }

    @Override
    public ArrangementAtomMatchCondition clone() {
        return new ArrangementAtomMatchCondition(this.myType, this.myValue);
    }

    public String toString() {
        if (this.myValue instanceof Boolean) {
            return String.format("%s%s", (Boolean)this.myValue != false ? "" : "not ", this.myType.getRepresentationValue());
        }
        return String.format("%s: %s", this.myType.getRepresentationValue(), this.myValue.toString().toLowerCase());
    }
}

