/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Set;

public class ByModifierArrangementEntryMatcher
implements ArrangementEntryMatcher {
    private final Set<ArrangementAtomMatchCondition> myModifiers = ContainerUtilRt.newHashSet();

    public ByModifierArrangementEntryMatcher(ArrangementAtomMatchCondition interestedModifier) {
        this.myModifiers.add(interestedModifier);
    }

    public ByModifierArrangementEntryMatcher(Collection<ArrangementAtomMatchCondition> interestedModifiers) {
        this.myModifiers.addAll(interestedModifiers);
    }

    @Override
    public boolean isMatched(ArrangementEntry entry) {
        if (entry instanceof ModifierAwareArrangementEntry) {
            Set<ArrangementSettingsToken> modifiers = ((ModifierAwareArrangementEntry)entry).getModifiers();
            for (ArrangementAtomMatchCondition condition : this.myModifiers) {
                Object value = condition.getValue();
                boolean isInverted = value instanceof Boolean && (Boolean)value == false;
                if (isInverted != modifiers.contains(condition.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.myModifiers).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByModifierArrangementEntryMatcher matcher = (ByModifierArrangementEntryMatcher)o;
        return ((Object)this.myModifiers).equals(matcher.myModifiers);
    }

    public String toString() {
        return "with modifiers " + this.myModifiers;
    }
}

