/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import java.util.regex.Pattern;

public abstract class AbstractRegexpArrangementMatcher
implements ArrangementEntryMatcher {
    private final String myPattern;
    private final Pattern myCompiledPattern;

    public AbstractRegexpArrangementMatcher(String pattern) {
        this.myPattern = pattern;
        Pattern p = null;
        try {
            p = Pattern.compile(pattern);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myCompiledPattern = p;
    }

    @Override
    public boolean isMatched(ArrangementEntry entry) {
        if (this.myCompiledPattern == null) {
            return false;
        }
        String text = this.getTextToMatch(entry);
        return text != null && this.myCompiledPattern.matcher(text).matches();
    }

    protected abstract String getTextToMatch(ArrangementEntry var1);

    public String getPattern() {
        return this.myPattern;
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRegexpArrangementMatcher that = (AbstractRegexpArrangementMatcher)o;
        return this.myPattern.equals(that.myPattern);
    }

    public String toString() {
        return String.format("regexp '%s'", this.myPattern);
    }
}

