/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public abstract class LanguageCodeStyleSettingsProvider {
    public static final ExtensionPointName<LanguageCodeStyleSettingsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.langCodeStyleSettingsProvider");

    public abstract Language getLanguage();

    public abstract String getCodeSample(SettingsType var1);

    public int getRightMargin(SettingsType settingsType) {
        return settingsType == SettingsType.WRAPPING_AND_BRACES_SETTINGS ? 30 : -1;
    }

    public void customizeSettings(CodeStyleSettingsCustomizable consumer, SettingsType settingsType) {
    }

    public String getFileExt() {
        return null;
    }

    public String getLanguageName() {
        return null;
    }

    public PsiFile createFileFromText(Project project, String text) {
        return null;
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        return null;
    }

    @Deprecated
    public PredefinedCodeStyle[] getPredefinedCodeStyles() {
        return PredefinedCodeStyle.EMPTY_ARRAY;
    }

    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.LANGUAGE_SETTINGS;
    }

    public static Language[] getLanguagesWithCodeStyleSettings() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (LanguageCodeStyleSettingsProvider provider : (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions(EP_NAME)) {
            languages.add(provider.getLanguage());
        }
        return languages.toArray(new Language[languages.size()]);
    }

    public static String getCodeSample(Language lang, SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getCodeSample(settingsType) : null;
    }

    public static int getRightMargin(Language lang, SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getRightMargin(settingsType) : -1;
    }

    public static Language getLanguage(String langName) {
        for (LanguageCodeStyleSettingsProvider provider : (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions(EP_NAME)) {
            String name = provider.getLanguageName();
            if (name == null) {
                name = provider.getLanguage().getDisplayName();
            }
            if (!langName.equals(name)) continue;
            return provider.getLanguage();
        }
        return null;
    }

    public static CommonCodeStyleSettings getDefaultCommonSettings(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getDefaultCommonSettings() : null;
    }

    public static String getFileExt(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getFileExt() : null;
    }

    public static String getLanguageName(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        String providerLangName = provider != null ? provider.getLanguageName() : null;
        return providerLangName != null ? providerLangName : lang.getDisplayName();
    }

    public static PsiFile createFileFromText(Language language, Project project, String text) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        return provider != null ? provider.createFileFromText(project, text) : null;
    }

    public static LanguageCodeStyleSettingsProvider forLanguage(Language language) {
        for (LanguageCodeStyleSettingsProvider provider : (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!((Object)((Object)provider.getLanguage())).equals((Object)language)) continue;
            return provider;
        }
        return null;
    }

    public static DisplayPriority getDisplayPriority(Language language) {
        LanguageCodeStyleSettingsProvider langProvider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        if (langProvider == null) {
            return DisplayPriority.LANGUAGE_SETTINGS;
        }
        return langProvider.getDisplayPriority();
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return null;
    }

    public Set<String> getSupportedFields() {
        SupportedFieldCollector fieldCollector = new SupportedFieldCollector();
        fieldCollector.collectFields();
        return fieldCollector.getCollectedFields();
    }

    private final class SupportedFieldCollector
    implements CodeStyleSettingsCustomizable {
        private final Set<String> myCollectedFields = new HashSet();
        private SettingsType myCurrSettingsType;

        private SupportedFieldCollector() {
        }

        public void collectFields() {
            SettingsType[] arr$ = SettingsType.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                SettingsType settingsType;
                this.myCurrSettingsType = settingsType = arr$[i$];
                LanguageCodeStyleSettingsProvider.this.customizeSettings(this, settingsType);
            }
        }

        @Override
        public void showAllStandardOptions() {
            switch (this.myCurrSettingsType) {
                case BLANK_LINES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.BlankLinesOption blankLinesOption : CodeStyleSettingsCustomizable.BlankLinesOption.values()) {
                        this.myCollectedFields.add(blankLinesOption.name());
                    }
                    break;
                }
                case SPACING_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.SpacingOption spacingOption : CodeStyleSettingsCustomizable.SpacingOption.values()) {
                        this.myCollectedFields.add(spacingOption.name());
                    }
                    break;
                }
                case WRAPPING_AND_BRACES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.WrappingOrBraceOption wrappingOrBraceOption : CodeStyleSettingsCustomizable.WrappingOrBraceOption.values()) {
                        this.myCollectedFields.add(wrappingOrBraceOption.name());
                    }
                    break;
                }
            }
        }

        @Override
        public void showStandardOptions(String ... optionNames) {
            this.myCollectedFields.addAll(Arrays.asList(optionNames));
        }

        @Override
        public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, Object ... options) {
            this.myCollectedFields.add(fieldName);
        }

        @Override
        public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFieldName, Object ... options) {
            this.myCollectedFields.add(fieldName);
        }

        @Override
        public void renameStandardOption(String fieldName, String newTitle) {
        }

        @Override
        public void moveStandardOption(String fieldName, String newGroup) {
        }

        public Set<String> getCollectedFields() {
            return this.myCollectedFields;
        }
    }

    public static enum SettingsType {
        BLANK_LINES_SETTINGS,
        SPACING_SETTINGS,
        WRAPPING_AND_BRACES_SETTINGS,
        INDENT_SETTINGS,
        LANGUAGE_SPECIFIC;

    }
}

