/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;

public abstract class JavaCodeStyleManager {
    public static final int DO_NOT_ADD_IMPORTS = 4096;
    public static final int UNCOMPLETE_CODE = 8192;

    public static JavaCodeStyleManager getInstance(Project project) {
        return ServiceManager.getService(project, JavaCodeStyleManager.class);
    }

    public abstract boolean addImport(PsiJavaFile var1, PsiClass var2);

    public abstract PsiElement shortenClassReferences(PsiElement var1, int var2) throws IncorrectOperationException;

    public abstract String getPrefixByVariableKind(VariableKind var1);

    public abstract String getSuffixByVariableKind(VariableKind var1);

    public abstract int findEntryIndex(PsiImportStatementBase var1);

    public abstract PsiElement shortenClassReferences(PsiElement var1) throws IncorrectOperationException;

    public abstract void shortenClassReferences(PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void optimizeImports(PsiFile var1) throws IncorrectOperationException;

    public abstract PsiImportList prepareOptimizeImportsResult(PsiJavaFile var1);

    public VariableKind getVariableKind(PsiVariable variable) {
        if (variable instanceof PsiField) {
            if (variable.hasModifierProperty("static")) {
                if (variable.hasModifierProperty("final")) {
                    return VariableKind.STATIC_FINAL_FIELD;
                }
                return VariableKind.STATIC_FIELD;
            }
            return VariableKind.FIELD;
        }
        if (variable instanceof PsiParameter) {
            if (((PsiParameter)variable).getDeclarationScope() instanceof PsiForeachStatement) {
                return VariableKind.LOCAL_VARIABLE;
            }
            return VariableKind.PARAMETER;
        }
        return VariableKind.LOCAL_VARIABLE;
    }

    public SuggestedNameInfo suggestVariableName(VariableKind kind, String propertyName, PsiExpression expr, PsiType type) {
        return this.suggestVariableName(kind, propertyName, expr, type, true);
    }

    public SuggestedNameInfo suggestCompiledParameterName(PsiType type) {
        return this.suggestVariableName(VariableKind.PARAMETER, null, null, type, true);
    }

    public abstract SuggestedNameInfo suggestVariableName(VariableKind var1, String var2, PsiExpression var3, PsiType var4, boolean var5);

    public abstract String variableNameToPropertyName(String var1, VariableKind var2);

    public abstract String propertyNameToVariableName(String var1, VariableKind var2);

    public abstract String suggestUniqueVariableName(String var1, PsiElement var2, boolean var3);

    public SuggestedNameInfo suggestUniqueVariableName(SuggestedNameInfo baseNameInfo, PsiElement place, boolean lookForward) {
        return this.suggestUniqueVariableName(baseNameInfo, place, false, lookForward);
    }

    public abstract SuggestedNameInfo suggestUniqueVariableName(SuggestedNameInfo var1, PsiElement var2, boolean var3, boolean var4);

    public abstract PsiElement qualifyClassReferences(PsiElement var1);

    public abstract void removeRedundantImports(PsiJavaFile var1) throws IncorrectOperationException;

    public abstract Collection<PsiImportStatementBase> findRedundantImports(PsiJavaFile var1);
}

