/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;

public class PsiWildcardType
extends PsiType.Stub {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.PsiWildcardType");
    private static final Key<PsiWildcardType> UNBOUNDED_WILDCARD = new Key("UNBOUNDED_WILDCARD");
    private static final String EXTENDS_PREFIX = "? extends ";
    private static final String SUPER_PREFIX = "? super ";
    private final PsiManager myManager;
    private final boolean myIsExtending;
    private final PsiType myBound;

    private PsiWildcardType(PsiManager manager, boolean isExtending, PsiType bound) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = manager;
        this.myIsExtending = isExtending;
        this.myBound = bound;
    }

    private PsiWildcardType(PsiWildcardType type, PsiAnnotation[] annotations) {
        super(annotations);
        this.myManager = type.myManager;
        this.myIsExtending = type.myIsExtending;
        this.myBound = type.myBound;
    }

    public static PsiWildcardType createUnbounded(PsiManager manager) {
        PsiWildcardType unboundedWildcard = (PsiWildcardType)manager.getUserData(UNBOUNDED_WILDCARD);
        if (unboundedWildcard == null) {
            unboundedWildcard = (PsiWildcardType)manager.putUserDataIfAbsent(UNBOUNDED_WILDCARD, new PsiWildcardType(manager, false, null));
        }
        return unboundedWildcard;
    }

    public static PsiWildcardType createExtends(PsiManager manager, PsiType bound) {
        LOG.assertTrue(!(bound instanceof PsiWildcardType));
        LOG.assertTrue(bound != PsiType.NULL);
        return new PsiWildcardType(manager, true, bound);
    }

    public static PsiWildcardType createSuper(PsiManager manager, PsiType bound) {
        LOG.assertTrue(!(bound instanceof PsiWildcardType));
        LOG.assertTrue(bound != PsiType.NULL);
        return new PsiWildcardType(manager, false, bound);
    }

    public PsiWildcardType annotate(PsiAnnotation[] annotations) {
        return annotations.length == 0 ? this : new PsiWildcardType(this, annotations);
    }

    @Override
    public String getPresentableText() {
        return this.getText(false, true, this.myBound == null ? null : this.myBound.getPresentableText());
    }

    @Override
    public String getCanonicalText(boolean annotated) {
        return this.getText(true, annotated, this.myBound == null ? null : this.myBound.getCanonicalText(annotated));
    }

    @Override
    public String getInternalCanonicalText() {
        return this.getText(true, true, this.myBound == null ? null : this.myBound.getInternalCanonicalText());
    }

    private String getText(boolean qualified, boolean annotated, String suffix) {
        PsiAnnotation[] annotations = this.getAnnotations();
        if (!(annotated && annotations.length != 0 || suffix != null)) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (annotated) {
            PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        }
        if (suffix == null) {
            sb.append('?');
        } else {
            sb.append(this.myIsExtending ? EXTENDS_PREFIX : SUPER_PREFIX);
            sb.append(suffix);
        }
        return sb.toString();
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope scope;
        if (this.myBound != null && (scope = this.myBound.getResolveScope()) != null) {
            return scope;
        }
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    @Override
    public PsiType[] getSuperTypes() {
        return new PsiType[]{this.getExtendsBound()};
    }

    @Override
    public boolean equalsToText(String text) {
        if (this.myBound == null) {
            return "?".equals(text);
        }
        if (this.myIsExtending) {
            return text.startsWith(EXTENDS_PREFIX) && this.myBound.equalsToText(text.substring(EXTENDS_PREFIX.length()));
        }
        return text.startsWith(SUPER_PREFIX) && this.myBound.equalsToText(text.substring(SUPER_PREFIX.length()));
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PsiWildcardType)) {
            return false;
        }
        PsiWildcardType that = (PsiWildcardType)o;
        if (this.myBound == null && that.myBound != null) {
            return that.isExtends() && that.myBound.equalsToText("java.lang.Object");
        }
        if (this.myBound != null && that.myBound == null) {
            return this.isExtends() && this.myBound.equalsToText("java.lang.Object");
        }
        return this.myIsExtending == that.myIsExtending && Comparing.equal((Object)this.myBound, (Object)that.myBound);
    }

    public int hashCode() {
        return (this.myIsExtending ? 1 : 0) + (this.myBound != null ? this.myBound.hashCode() : 0);
    }

    public PsiType getBound() {
        return this.myBound;
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitWildcardType(this);
    }

    @Override
    public boolean isValid() {
        return this.myBound == null || this.myBound.isValid();
    }

    public boolean isExtends() {
        return this.myBound != null && this.myIsExtending;
    }

    public boolean isSuper() {
        return this.myBound != null && !this.myIsExtending;
    }

    public boolean isBounded() {
        return this.myBound != null;
    }

    public PsiType getExtendsBound() {
        if (this.myBound == null || !this.myIsExtending) {
            return PsiWildcardType.getJavaLangObject(this.myManager, this.getResolveScope());
        }
        return this.myBound;
    }

    public PsiType getSuperBound() {
        return this.myBound == null || this.myIsExtending ? NULL : this.myBound;
    }
}

