/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.List;

public class PsiDisjunctionType
extends PsiType.Stub {
    private final PsiManager myManager;
    private final List<PsiType> myTypes;
    private final CachedValue<PsiType> myLubCache;

    public PsiDisjunctionType(List<PsiType> types, PsiManager psiManager) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = psiManager;
        this.myTypes = Collections.unmodifiableList(types);
        this.myLubCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new CachedValueProvider<PsiType>(){

            @Override
            public CachedValueProvider.Result<PsiType> compute() {
                PsiType lub = (PsiType)PsiDisjunctionType.this.myTypes.get(0);
                for (int i = 1; i < PsiDisjunctionType.this.myTypes.size(); ++i) {
                    if ((lub = GenericsUtil.getLeastUpperBound(lub, (PsiType)PsiDisjunctionType.this.myTypes.get(i), PsiDisjunctionType.this.myManager)) != null) continue;
                    lub = PsiType.getJavaLangObject(PsiDisjunctionType.this.myManager, GlobalSearchScope.allScope(PsiDisjunctionType.this.myManager.getProject()));
                    break;
                }
                return CachedValueProvider.Result.create(lub, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        }, false);
    }

    public static PsiType createDisjunction(List<PsiType> types, PsiManager psiManager) {
        assert (!types.isEmpty());
        return types.size() == 1 ? types.get(0) : new PsiDisjunctionType(types, psiManager);
    }

    public PsiType getLeastUpperBound() {
        return this.myLubCache.getValue();
    }

    public List<PsiType> getDisjunctions() {
        return this.myTypes;
    }

    public PsiDisjunctionType newDisjunctionType(List<PsiType> types) {
        return new PsiDisjunctionType(types, this.myManager);
    }

    @Override
    public String getPresentableText() {
        return StringUtil.join(this.myTypes, (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getPresentableText();
            }
        }, (String)" | ");
    }

    @Override
    public String getCanonicalText(final boolean annotated) {
        return StringUtil.join(this.myTypes, (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getCanonicalText(annotated);
            }
        }, (String)" | ");
    }

    @Override
    public String getInternalCanonicalText() {
        return StringUtil.join(this.myTypes, (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getInternalCanonicalText();
            }
        }, (String)" | ");
    }

    @Override
    public boolean isValid() {
        for (PsiType type : this.myTypes) {
            if (type.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(String text) {
        return Comparing.equal((String)text, (String)this.getCanonicalText());
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitDisjunctionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.getLeastUpperBound().getResolveScope();
    }

    @Override
    public PsiType[] getSuperTypes() {
        PsiType lub = this.getLeastUpperBound();
        if (lub instanceof PsiIntersectionType) {
            return ((PsiIntersectionType)lub).getConjuncts();
        }
        return new PsiType[]{lub};
    }

    public int hashCode() {
        return this.myTypes.get(0).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiDisjunctionType that = (PsiDisjunctionType)o;
        if (that.myTypes.size() != this.myTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.myTypes.size(); ++i) {
            if (this.myTypes.get(i).equals(that.myTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

