/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;

public class IdentitySmartPointer<T extends PsiElement>
implements SmartPsiElementPointer<T> {
    private final T myElement;
    private final PsiFile myFile;

    public IdentitySmartPointer(T element, PsiFile file) {
        this.myElement = element;
        this.myFile = file;
    }

    public IdentitySmartPointer(T element) {
        this(element, element.getContainingFile());
    }

    @Override
    public Project getProject() {
        return this.myFile.getProject();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myFile.getVirtualFile();
    }

    @Override
    public T getElement() {
        T element = this.myElement;
        return (T)(element.isValid() ? element : null);
    }

    public int hashCode() {
        T elt = this.getElement();
        return elt == null ? 0 : elt.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPointerManager.getInstance(this.getProject()).pointToTheSameElement(this, (SmartPsiElementPointer)obj);
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public Segment getRange() {
        return this.myElement.getTextRange();
    }
}

