/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Collection;

public abstract class FileContextProvider {
    public static final ExtensionPointName<FileContextProvider> EP_NAME = new ExtensionPointName("com.intellij.fileContextProvider");

    public static FileContextProvider getProvider(PsiFile file) {
        for (FileContextProvider provider : (FileContextProvider[])Extensions.getExtensions(EP_NAME, (AreaInstance)file.getProject())) {
            if (!provider.isAvailable(file)) continue;
            return provider;
        }
        return null;
    }

    protected abstract boolean isAvailable(PsiFile var1);

    public abstract Collection<PsiFileSystemItem> getContextFolders(PsiFile var1);

    public abstract PsiFile getContextFile(PsiFile var1);
}

