/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.InstanceofCheckerGenerator;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class ObjectPattern<T, Self extends ObjectPattern<T, Self>>
implements Cloneable,
ElementPattern<T> {
    private ElementPatternCondition<T> myCondition;

    protected ObjectPattern(InitialPatternCondition<T> condition) {
        this.myCondition = new ElementPatternCondition<T>(condition);
    }

    protected ObjectPattern(Class<T> aClass) {
        final Condition checker = InstanceofCheckerGenerator.getInstance().getInstanceofChecker(aClass);
        this.myCondition = new ElementPatternCondition(new InitialPatternCondition<T>(aClass){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                return checker.value(o);
            }
        });
    }

    @Override
    public final boolean accepts(Object t) {
        return this.myCondition.accepts(t, new ProcessingContext());
    }

    @Override
    public boolean accepts(Object o, ProcessingContext context) {
        return this.myCondition.accepts(o, context);
    }

    @Override
    public final ElementPatternCondition getCondition() {
        return this.myCondition;
    }

    public Self andNot(ElementPattern pattern) {
        Capture not = StandardPatterns.not(pattern);
        return this.and(not);
    }

    public Self andOr(ElementPattern ... patterns) {
        ElementPattern or = StandardPatterns.or(patterns);
        return this.and(or);
    }

    public Self and(ElementPattern pattern) {
        return this.with(new PatternConditionPlus<T, T>("and", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<T, ProcessingContext> processor) {
                return processor.process(t, (Object)context);
            }
        });
    }

    public Self equalTo(final T o) {
        return this.with(new ValuePatternCondition<T>("equalTo"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return t.equals(o);
            }

            @Override
            public Collection<T> getValues() {
                return Collections.singletonList(o);
            }
        });
    }

    public Self oneOf(T ... values) {
        int length = values.length;
        final Collection<T> list = length == 1 ? Collections.singletonList(values[0]) : (length >= 11 ? new HashSet<T>(Arrays.asList(values)) : Arrays.asList(values));
        return this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return list;
            }

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return list.contains(t);
            }
        });
    }

    public Self oneOf(final Collection<T> set) {
        return this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return set;
            }

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return set.contains(t);
            }
        });
    }

    public Self isNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                return o == null;
            }
        }));
    }

    public Self notNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                return o != null;
            }
        }));
    }

    public Self save(final Key<? super T> key) {
        return this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                context.put(key, t);
                return true;
            }
        });
    }

    public Self save(final String key) {
        return this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                context.put((Object)key, t);
                return true;
            }
        });
    }

    public Self with(PatternCondition<? super T> pattern) {
        ElementPatternCondition<? super T> condition = this.myCondition.append(pattern);
        return this.adapt(condition);
    }

    private Self adapt(ElementPatternCondition<T> condition) {
        try {
            ObjectPattern s = (ObjectPattern)this.clone();
            s.myCondition = condition;
            return (Self)s;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Self without(final PatternCondition<? super T> pattern) {
        return this.with(new PatternCondition<T>("without"){

            @Override
            public boolean accepts(T o, ProcessingContext context) {
                return !pattern.accepts(o, context);
            }
        });
    }

    public String toString() {
        return this.myCondition.toString();
    }

    public static class Capture<T>
    extends ObjectPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(InitialPatternCondition<T> condition) {
            super(condition);
        }
    }
}

