/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;

public class ElementPatternCondition<T> {
    private final InitialPatternCondition<T> myInitialCondition;
    private final List<PatternCondition<? super T>> myConditions;

    public ElementPatternCondition(InitialPatternCondition<T> startCondition) {
        this.myInitialCondition = startCondition;
        this.myConditions = Collections.emptyList();
    }

    protected ElementPatternCondition(ElementPatternCondition<T> original, PatternCondition<? super T> condition) {
        this.myInitialCondition = original.getInitialCondition();
        this.myConditions = new SmartList(original.getConditions());
        this.myConditions.add(condition);
    }

    @Deprecated
    public boolean accepts(Object o, ProcessingContext context) {
        if (!this.myInitialCondition.accepts(o, context)) {
            return false;
        }
        int listSize = this.myConditions.size();
        for (int i = 0; i < listSize; ++i) {
            if (this.myConditions.get(i).accepts(o, context)) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(StringBuilder builder, String indent) {
        this.myInitialCondition.append(builder, indent);
        int conditionSize = this.myConditions.size();
        for (int i = 0; i < conditionSize; ++i) {
            PatternCondition<T> condition = this.myConditions.get(i);
            condition.append(builder.append(".\n").append(indent), indent);
        }
    }

    public List<PatternCondition<? super T>> getConditions() {
        return this.myConditions;
    }

    public InitialPatternCondition<T> getInitialCondition() {
        return this.myInitialCondition;
    }

    public ElementPatternCondition<T> append(PatternCondition<? super T> condition) {
        return new ElementPatternCondition<T>(this, condition);
    }
}

