/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.ui;

import java.util.ArrayList;
import java.util.List;

public class ManifestFileConfiguration {
    private final boolean myWritable;
    private List<String> myClasspath = new ArrayList<String>();
    private String myMainClass;
    private String myManifestFilePath;

    public ManifestFileConfiguration(ManifestFileConfiguration configuration) {
        this.myWritable = configuration.isWritable();
        this.myClasspath.addAll(configuration.getClasspath());
        this.myMainClass = configuration.getMainClass();
        this.myManifestFilePath = configuration.getManifestFilePath();
    }

    public ManifestFileConfiguration(String manifestFilePath, List<String> classpath, String mainClass, boolean isWritable) {
        this.myWritable = isWritable;
        if (classpath != null) {
            this.myClasspath.addAll(classpath);
        }
        this.myMainClass = mainClass;
        this.myManifestFilePath = manifestFilePath;
    }

    public List<String> getClasspath() {
        return this.myClasspath;
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    public void setClasspath(List<String> classpath) {
        this.myClasspath = classpath;
    }

    public String getMainClass() {
        return this.myMainClass;
    }

    public void setMainClass(String mainClass) {
        this.myMainClass = mainClass;
    }

    public String getManifestFilePath() {
        return this.myManifestFilePath;
    }

    public void setManifestFilePath(String manifestFilePath) {
        this.myManifestFilePath = manifestFilePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManifestFileConfiguration)) {
            return false;
        }
        ManifestFileConfiguration that = (ManifestFileConfiguration)o;
        if (!((Object)this.myClasspath).equals(that.myClasspath)) {
            return false;
        }
        if (this.myMainClass != null ? !this.myMainClass.equals(that.myMainClass) : that.myMainClass != null) {
            return false;
        }
        return !(this.myManifestFilePath != null ? !this.myManifestFilePath.equals(that.myManifestFilePath) : that.myManifestFilePath != null);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public void addToClasspath(List<String> classpath) {
        for (String path : classpath) {
            if (this.myClasspath.contains(path)) continue;
            this.myClasspath.add(path);
        }
    }
}

