/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.artifacts;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public abstract class ArtifactType {
    public static final ExtensionPointName<ArtifactType> EP_NAME = ExtensionPointName.create((String)"com.intellij.packaging.artifactType");
    private final String myId;
    private final String myTitle;

    protected ArtifactType(String id, String title) {
        this.myId = id;
        this.myTitle = title;
    }

    public final String getId() {
        return this.myId;
    }

    public String getPresentableName() {
        return this.myTitle;
    }

    public abstract Icon getIcon();

    public String getDefaultPathFor(PackagingSourceItem sourceItem) {
        return this.getDefaultPathFor(sourceItem.getKindOfProducedElements());
    }

    public abstract String getDefaultPathFor(PackagingElementOutputKind var1);

    public boolean isSuitableItem(PackagingSourceItem sourceItem) {
        return true;
    }

    public static ArtifactType[] getAllTypes() {
        return (ArtifactType[])Extensions.getExtensions(EP_NAME);
    }

    public static ArtifactType findById(String id) {
        for (ArtifactType type : ArtifactType.getAllTypes()) {
            if (!id.equals(type.getId())) continue;
            return type;
        }
        return null;
    }

    public abstract CompositePackagingElement<?> createRootElement(String var1);

    public List<? extends ArtifactTemplate> getNewArtifactTemplates(PackagingElementResolvingContext context) {
        return Collections.emptyList();
    }

    public void checkRootElement(CompositePackagingElement<?> rootElement, Artifact artifact, ArtifactProblemsHolder manager) {
    }

    public List<? extends PackagingElement<?>> getSubstitution(Artifact artifact, PackagingElementResolvingContext context, ArtifactType parentType) {
        return null;
    }
}

