/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Comparator;

public abstract class ArtifactManager
implements ArtifactModel {
    public static final Topic<ArtifactListener> TOPIC = Topic.create((String)"artifacts changes", ArtifactListener.class);
    public static final Comparator<Artifact> ARTIFACT_COMPARATOR = new Comparator<Artifact>(){

        @Override
        public int compare(Artifact o1, Artifact o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public static ArtifactManager getInstance(Project project) {
        return project.getComponent(ArtifactManager.class);
    }

    public abstract Artifact[] getSortedArtifacts();

    public abstract ModifiableArtifactModel createModifiableModel();

    public abstract PackagingElementResolvingContext getResolvingContext();

    public abstract Artifact addArtifact(String var1, ArtifactType var2, CompositePackagingElement<?> var3);

    public abstract void addElementsToDirectory(Artifact var1, String var2, Collection<? extends PackagingElement<?>> var3);

    public abstract void addElementsToDirectory(Artifact var1, String var2, PackagingElement<?> var3);

    public abstract ModificationTracker getModificationTracker();
}

