/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.Gray;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public interface StatusBarWidget
extends Disposable {
    public String ID();

    public WidgetPresentation getPresentation(PlatformType var1);

    public void install(StatusBar var1);

    public static class WidgetBorder
    implements Border {
        public static final WidgetBorder INSTANCE = new WidgetBorder();
        private static final Color TOP = Gray._227;
        private static final Color LEFT1_FROM = Gray._161;
        private static final Color LEFT1_TO = Gray._133;
        private static final Color LEFT2_FROM = Gray._220;
        private static final Color LEFT2_TO = Gray._184;
        private static final Color LEFT1_FROM_INACTIVE;
        private static final Color PIXEL;
        private static final Color LEFT1_TO_INACTIVE;
        private static final Color SEPARATOR_COLOR;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (UIUtil.isUnderDarcula()) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            if (SystemInfo.isMac) {
                Window window = SwingUtilities.getWindowAncestor(c);
                if (window != null && window.isActive()) {
                    g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)LEFT1_FROM, (float)0.0f, (float)height, (Color)LEFT1_TO));
                    g2.drawLine(x, y, x, y + height);
                    g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)LEFT2_FROM, (float)0.0f, (float)height, (Color)LEFT2_TO));
                    g2.drawLine(x + 1, y, x + 1, y + height);
                    g2.setColor(PIXEL);
                    g2.drawLine(x, y, x, y);
                    g2.setColor(TOP);
                    g2.drawLine(x + 2, y, x + width - 2, y);
                } else {
                    g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)LEFT1_FROM_INACTIVE, (float)0.0f, (float)height, (Color)LEFT1_TO_INACTIVE));
                    g2.drawLine(x, y, x, y + height);
                }
            } else {
                g2.setColor((Color)(UIUtil.isUnderIntelliJLaF() ? Gray._200 : SEPARATOR_COLOR));
                g2.drawLine(x, y, x, y + height);
            }
            g2.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 4, 0, 2);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        static {
            PIXEL = LEFT1_FROM_INACTIVE = Gray._190;
            LEFT1_TO_INACTIVE = Gray._180;
            SEPARATOR_COLOR = UIUtil.getPanelBackground().darker();
        }
    }

    public static interface MultipleTextValuesPresentation
    extends WidgetPresentation {
        public ListPopup getPopupStep();

        public String getSelectedValue();

        @Deprecated
        public String getMaxValue();
    }

    public static interface TextPresentation
    extends WidgetPresentation {
        public String getText();

        @Deprecated
        public String getMaxPossibleText();

        public float getAlignment();
    }

    public static interface IconPresentation
    extends WidgetPresentation {
        public Icon getIcon();
    }

    public static interface WidgetPresentation {
        public String getTooltipText();

        public Consumer<MouseEvent> getClickConsumer();
    }

    public static interface Multiframe
    extends StatusBarWidget {
        public StatusBarWidget copy();
    }

    public static enum PlatformType {
        DEFAULT,
        MAC;

    }
}

