/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public class VFileCreateEvent
extends VFileEvent {
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final String myChildName;
    private final boolean myReCreation;
    private VirtualFile myCreatedFile;

    public VFileCreateEvent(Object requestor, VirtualFile parent, String childName, boolean isDirectory, boolean isFromRefresh) {
        this(requestor, parent, childName, isDirectory, isFromRefresh, false);
    }

    public VFileCreateEvent(Object requestor, VirtualFile parent, String childName, boolean isDirectory, boolean isFromRefresh, boolean isReCreation) {
        super(requestor, isFromRefresh);
        this.myChildName = childName;
        this.myParent = parent;
        this.myDirectory = isDirectory;
        this.myReCreation = isReCreation;
    }

    public String getChildName() {
        return this.myChildName;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public boolean isReCreation() {
        return this.myReCreation;
    }

    public String toString() {
        return "VfsEvent[" + (this.myReCreation ? "re" : "") + "create " + (this.myDirectory ? "dir " : "file ") + this.myChildName + " in " + this.myParent.getUrl() + "]";
    }

    @Override
    public String getPath() {
        return this.myParent.getPath() + "/" + this.myChildName;
    }

    @Override
    public VirtualFile getFile() {
        if (this.myCreatedFile != null) {
            return this.myCreatedFile;
        }
        this.myCreatedFile = this.myParent.findChild(this.myChildName);
        return this.myCreatedFile;
    }

    public void resetCache() {
        this.myCreatedFile = null;
    }

    @Override
    public VirtualFileSystem getFileSystem() {
        return this.myParent.getFileSystem();
    }

    @Override
    public boolean isValid() {
        if (this.myParent.isValid()) {
            VirtualFile child = this.myParent.findChild(this.myChildName);
            return !this.myReCreation && child == null || this.myReCreation && child != null;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        if (this.myDirectory != event.myDirectory) {
            return false;
        }
        if (!this.myChildName.equals(event.myChildName)) {
            return false;
        }
        if (!this.myParent.equals(event.myParent)) {
            return false;
        }
        return this.myReCreation == event.myReCreation;
    }

    @Override
    public int hashCode() {
        int result = this.myParent.hashCode();
        result = 31 * result + (this.myDirectory ? 1 : 0);
        result = 31 * result + this.myChildName.hashCode();
        result = 31 * result + (this.myReCreation ? 1 : 0);
        return result;
    }
}

