/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.List;
import java.util.Map;

public abstract class VirtualFileVisitor<T> {
    public static final Option NO_FOLLOW_SYMLINKS = new Option();
    public static final Option SKIP_ROOT = new Option();
    public static final Option ONE_LEVEL_DEEP = VirtualFileVisitor.limit(1);
    public static final Result CONTINUE = new Result(false, null);
    public static final Result SKIP_CHILDREN = new Result(true, null);
    private boolean myFollowSymLinks = true;
    private boolean mySkipRoot = false;
    private int myDepthLimit = -1;
    private Map<VirtualFile, List<VirtualFile>> myVisitedTargets;
    private int myLevel = 0;
    private Stack<T> myValueStack = null;
    private T myValue = null;

    public static Option limit(int maxDepth) {
        return new Option.LimitOption(maxDepth);
    }

    public static Result skipTo(VirtualFile parentToSkipTo) {
        return new Result(true, parentToSkipTo);
    }

    protected VirtualFileVisitor(Option ... options) {
        for (Option option : options) {
            if (option == NO_FOLLOW_SYMLINKS) {
                this.myFollowSymLinks = false;
                continue;
            }
            if (option == SKIP_ROOT) {
                this.mySkipRoot = true;
                continue;
            }
            if (!(option instanceof Option.LimitOption)) continue;
            this.myDepthLimit = ((Option.LimitOption)option).limit;
        }
        if (this.myFollowSymLinks) {
            this.myVisitedTargets = ContainerUtil.newHashMap();
        }
    }

    public boolean visitFile(VirtualFile file) {
        return true;
    }

    public Result visitFileEx(VirtualFile file) {
        return this.visitFile(file) ? CONTINUE : SKIP_CHILDREN;
    }

    public void afterChildrenVisited(VirtualFile file) {
    }

    public Iterable<VirtualFile> getChildrenIterable(VirtualFile file) {
        return null;
    }

    public final void setValueForChildren(T value) {
        this.myValue = value;
        if (this.myValueStack == null) {
            this.myValueStack = new Stack();
        }
    }

    public final T getCurrentValue() {
        return this.myValue;
    }

    final boolean allowVisitFile(VirtualFile file) {
        return this.myLevel > 0 || !this.mySkipRoot;
    }

    final boolean allowVisitChildren(VirtualFile file) {
        if (!file.is(VFileProperty.SYMLINK)) {
            return true;
        }
        if (!this.myFollowSymLinks || VfsUtilCore.isInvalidLink(file)) {
            return false;
        }
        VirtualFile target = file.getCanonicalFile();
        List<VirtualFile> links = this.myVisitedTargets.get(target);
        if (links == null) {
            this.myVisitedTargets.put(target, ContainerUtil.newSmartList((Object)file));
            return true;
        }
        boolean hasLoop = false;
        for (VirtualFile link : links) {
            if (!VfsUtilCore.isAncestor(link, file, true)) continue;
            hasLoop = true;
            break;
        }
        links.add(file);
        return !hasLoop;
    }

    final boolean depthLimitReached() {
        return this.myDepthLimit >= 0 && this.myLevel >= this.myDepthLimit;
    }

    final void saveValue() {
        ++this.myLevel;
        if (this.myValueStack != null) {
            this.myValueStack.push(this.myValue);
        }
    }

    final void restoreValue(boolean pushed) {
        if (pushed) {
            --this.myLevel;
            if (this.myValueStack != null && !this.myValueStack.isEmpty()) {
                this.myValueStack.pop();
            }
        }
        if (this.myValueStack != null) {
            this.myValue = this.myValueStack.isEmpty() ? null : this.myValueStack.peek();
        }
    }

    protected static class VisitorException
    extends RuntimeException {
        public VisitorException(Throwable cause) {
            super(cause);
        }
    }

    public static class Result {
        public final boolean skipChildren;
        public final VirtualFile skipToParent;

        private Result(boolean skipChildren, VirtualFile skipToParent) {
            this.skipChildren = skipChildren;
            this.skipToParent = skipToParent;
        }

        public String toString() {
            return "(" + (this.skipChildren ? "skip," + this.skipToParent : "continue") + ")";
        }
    }

    public static class Option {
        private Option() {
        }

        private static class LimitOption
        extends Option {
            private final int limit;

            private LimitOption(int limit) {
                this.limit = limit;
            }
        }
    }
}

