/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import java.io.File;
import java.io.IOException;

public abstract class VirtualFileSystem {
    protected VirtualFileSystem() {
    }

    public abstract String getProtocol();

    public abstract VirtualFile findFileByPath(String var1);

    public String extractPresentableUrl(String path) {
        return path.replace('/', File.separatorChar);
    }

    public abstract void refresh(boolean var1);

    public abstract VirtualFile refreshAndFindFileByPath(String var1);

    public abstract void addVirtualFileListener(VirtualFileListener var1);

    public abstract void removeVirtualFileListener(VirtualFileListener var1);

    public void forceRefreshFile(boolean asynchronous, VirtualFile file) {
        file.refresh(asynchronous, false);
    }

    protected abstract void deleteFile(Object var1, VirtualFile var2) throws IOException;

    protected abstract void moveFile(Object var1, VirtualFile var2, VirtualFile var3) throws IOException;

    protected abstract void renameFile(Object var1, VirtualFile var2, String var3) throws IOException;

    protected abstract VirtualFile createChildFile(Object var1, VirtualFile var2, String var3) throws IOException;

    protected abstract VirtualFile createChildDirectory(Object var1, VirtualFile var2, String var3) throws IOException;

    protected abstract VirtualFile copyFile(Object var1, VirtualFile var2, VirtualFile var3, String var4) throws IOException;

    public abstract boolean isReadOnly();

    public boolean isCaseSensitive() {
        return true;
    }
}

