/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.messages.Topic;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic("NewVirtualFileSystem changes", BulkFileListener.class);

    public static VirtualFileManager getInstance() {
        return ApplicationManager.getApplication().getComponent(VirtualFileManager.class);
    }

    public abstract VirtualFileSystem getFileSystem(String var1);

    public abstract long syncRefresh();

    public abstract long asyncRefresh(Runnable var1);

    public abstract void refreshWithoutFileWatcher(boolean var1);

    public abstract VirtualFile findFileByUrl(String var1);

    public abstract VirtualFile refreshAndFindFileByUrl(String var1);

    public abstract void addVirtualFileListener(VirtualFileListener var1);

    public abstract void addVirtualFileListener(VirtualFileListener var1, Disposable var2);

    public abstract void removeVirtualFileListener(VirtualFileListener var1);

    public static String constructUrl(String protocol, String path) {
        return protocol + "://" + path;
    }

    public static String extractProtocol(String url) {
        int index = url.indexOf("://");
        if (index < 0) {
            return null;
        }
        return url.substring(0, index);
    }

    public static String extractPath(String url) {
        int index = url.indexOf("://");
        if (index < 0) {
            return url;
        }
        return url.substring(index + "://".length());
    }

    public abstract void addVirtualFileManagerListener(VirtualFileManagerListener var1);

    public abstract void addVirtualFileManagerListener(VirtualFileManagerListener var1, Disposable var2);

    public abstract void removeVirtualFileManagerListener(VirtualFileManagerListener var1);

    public abstract void notifyPropertyChanged(VirtualFile var1, String var2, Object var3, Object var4);
}

