/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.DistinctRootsCollection;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VfsUtilCore");
    private static final String MAILTO = "mailto";
    public static final String LOCALHOST_URI_PATH_PREFIX = "localhost/";
    public static final char VFS_SEPARATOR_CHAR = '/';
    private static final String PROTOCOL_DELIMITER = ":";

    public static boolean isAncestor(VirtualFile ancestor, VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isUnder(VirtualFile file, Set<VirtualFile> roots) {
        if (roots == null || roots.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file; parent != null; parent = parent.getParent()) {
            if (!roots.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnder(String url, Collection<String> rootUrls) {
        if (rootUrls == null || rootUrls.isEmpty()) {
            return false;
        }
        for (String excludesUrl : rootUrls) {
            if (!VfsUtilCore.isEqualOrAncestor(excludesUrl, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualOrAncestor(String ancestorUrl, String fileUrl) {
        if (ancestorUrl.equals(fileUrl)) {
            return true;
        }
        if (StringUtil.endsWithChar((CharSequence)ancestorUrl, (char)'/')) {
            return fileUrl.startsWith(ancestorUrl);
        }
        return StringUtil.startsWithConcatenation((String)fileUrl, (String[])new String[]{ancestorUrl, "/"});
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) {
        File parent;
        File file2 = parent = strict ? file.getParentFile() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParentFile();
        }
        return false;
    }

    public static String getRelativePath(VirtualFile file, VirtualFile ancestor) {
        return VfsUtilCore.getRelativePath(file, ancestor, '/');
    }

    public static String getRelativePath(VirtualFile file, VirtualFile ancestor, char separator) {
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getNameSequence().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            CharSequence name = parent.getNameSequence();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return StringFactory.createShared((char[])chars);
    }

    public static VirtualFile getVirtualFileForJar(VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    public static VirtualFile copyFile(Object requestor, VirtualFile file, VirtualFile toDir) throws IOException {
        return VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
    }

    public static VirtualFile copyFile(Object requestor, VirtualFile file, VirtualFile toDir, String newName) throws IOException {
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray());
        return newChild;
    }

    public static InputStream byteStreamSkippingBOM(byte[] buf, VirtualFile file) throws IOException {
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)stream, file);
    }

    public static InputStream inputStreamSkippingBOM(InputStream stream, VirtualFile file) throws IOException {
        return CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
    }

    public static OutputStream outputStreamAddingBOM(OutputStream stream, VirtualFile file) throws IOException {
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream.write(bom);
        }
        return stream;
    }

    public static boolean iterateChildrenRecursively(final VirtualFile root, final VirtualFileFilter filter, final ContentIterator iterator) {
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                if (filter != null && !filter.accept(file)) {
                    return SKIP_CHILDREN;
                }
                if (!iterator.processFile(file)) {
                    return 1.skipTo(root);
                }
                return CONTINUE;
            }
        });
        return !Comparing.equal((Object)result.skipToParent, (Object)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualFileVisitor.Result visitChildrenRecursively(VirtualFile file, VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        boolean pushed = false;
        try {
            boolean visited = visitor.allowVisitFile(file);
            if (visited) {
                VirtualFileVisitor.Result result = visitor.visitFileEx(file);
                if (result.skipChildren) {
                    VirtualFileVisitor.Result result2 = result;
                    return result2;
                }
            }
            Iterable<VirtualFile> childrenIterable = null;
            VirtualFile[] children = null;
            try {
                if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                    children = file.getChildren();
                }
            }
            catch (InvalidVirtualFileAccessException e) {
                LOG.info("Ignoring: " + e.getMessage());
                VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                visitor.restoreValue(pushed);
                return result;
            }
            if (childrenIterable != null) {
                visitor.saveValue();
                pushed = true;
                for (VirtualFile child : childrenIterable) {
                    VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result3 = result;
                    return result3;
                }
            } else if (children != null && children.length != 0) {
                visitor.saveValue();
                pushed = true;
                for (VirtualFile child : children) {
                    VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result4 = result;
                    return result4;
                }
            }
            if (visited) {
                visitor.afterChildrenVisited(file);
            }
            VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
            return result;
        }
        finally {
            visitor.restoreValue(pushed);
        }
    }

    public static <E extends Exception> VirtualFileVisitor.Result visitChildrenRecursively(VirtualFile file, VirtualFileVisitor visitor, Class<E> eClass) throws E {
        try {
            return VfsUtilCore.visitChildrenRecursively(file, visitor);
        }
        catch (VirtualFileVisitor.VisitorException e) {
            Throwable cause = e.getCause();
            if (eClass.isInstance(cause)) {
                throw (Exception)eClass.cast(cause);
            }
            throw e;
        }
    }

    public static boolean isBrokenLink(VirtualFile file) {
        return file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null;
    }

    public static boolean isInvalidLink(VirtualFile link) {
        VirtualFile target = link.getCanonicalFile();
        return target == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    public static String loadText(VirtualFile file) throws IOException {
        return VfsUtilCore.loadText(file, (int)file.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(VirtualFile file, int length) throws IOException {
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        try {
            String string = StringFactory.createShared((char[])FileUtil.loadText((Reader)reader, (int)length));
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static VirtualFile[] toVirtualFileArray(Collection<? extends VirtualFile> files) {
        int size = files.size();
        if (size == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return files.toArray(new VirtualFile[size]);
    }

    public static String urlToPath(String url) {
        if (url == null) {
            return "";
        }
        return VirtualFileManager.extractPath(url);
    }

    public static File virtualToIoFile(VirtualFile file) {
        return new File(PathUtil.toPresentableUrl(file.getUrl()));
    }

    public static String pathToUrl(String path) {
        return VirtualFileManager.constructUrl("file", path);
    }

    public static List<File> virtualToIoFiles(Collection<VirtualFile> scope) {
        return ContainerUtil.map2List(scope, (Function)new Function<VirtualFile, File>(){

            public File fun(VirtualFile file) {
                return VfsUtilCore.virtualToIoFile(file);
            }
        });
    }

    public static String toIdeaUrl(String url) {
        return VfsUtilCore.toIdeaUrl(url, true);
    }

    public static String toIdeaUrl(String url, boolean removeLocalhostPrefix) {
        int index = url.indexOf(":/");
        if (index < 0 || index + 2 >= url.length()) {
            return url;
        }
        if (url.charAt(index + 2) != '/') {
            String prefix = url.substring(0, index);
            String suffix = url.substring(index + 2);
            if (SystemInfoRt.isWindows) {
                return prefix + "://" + suffix;
            }
            if (removeLocalhostPrefix && prefix.equals("file") && suffix.startsWith(LOCALHOST_URI_PATH_PREFIX)) {
                return prefix + ":///" + suffix.substring(LOCALHOST_URI_PATH_PREFIX.length());
            }
            return prefix + ":///" + suffix;
        }
        if (url.charAt(index + 3) == '/' && SystemInfoRt.isWindows && url.regionMatches(0, "file://", 0, "file://".length())) {
            char c;
            for (int i = index + 4; i < url.length() && (c = url.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                return "file://" + url.substring(index + 4);
            }
            return url;
        }
        return url;
    }

    public static String fixURLforIDEA(String url) {
        return VfsUtilCore.toIdeaUrl(url, false);
    }

    public static String convertFromUrl(URL url) {
        String protocol = url.getProtocol();
        String path = url.getPath();
        if (protocol.equals("jar")) {
            if (StringUtil.startsWithConcatenation((String)path, (String[])new String[]{"file", PROTOCOL_DELIMITER})) {
                try {
                    URL subURL = new URL(path);
                    path = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(VfsBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(VfsBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (!path.isEmpty() && path.charAt(0) == '/') {
                path = path.substring(1, path.length());
            }
        }
        path = URLUtil.unescapePercentSequences((String)path);
        return protocol + "://" + path;
    }

    public static URL convertToURL(String vfsUrl) {
        if (vfsUrl.startsWith("jar://")) {
            try {
                return new URL("jar:file:///" + vfsUrl.substring("jar://".length()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split = vfsUrl.split("://");
        if (split.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split[0];
        String path = split[1];
        try {
            if (protocol.equals("file")) {
                return new URL("file", "", path);
            }
            return UrlClassLoader.internProtocol((URL)new URL(vfsUrl));
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occurred:" + e.getMessage());
            return null;
        }
    }

    public static String fixIDEAUrl(String ideaUrl) {
        int idx = ideaUrl.indexOf("://");
        if (idx >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals("jar")) {
                s = "jar:file";
            }
            ideaUrl = s + ":/" + ideaUrl.substring(idx + 3);
        }
        return ideaUrl;
    }

    public static VirtualFile findRelativeFile(String uri, VirtualFile base) {
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:")) {
            uri = uri.substring("file:".length());
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (!SystemInfo.isWindows && StringUtil.startsWithChar((CharSequence)uri, (char)'/')) {
            file = StandardFileSystems.local().findFileByPath(uri);
        } else if (SystemInfo.isWindows && uri.length() >= 2 && Character.isLetter(uri.charAt(0)) && uri.charAt(1) == ':') {
            file = StandardFileSystems.local().findFileByPath(uri);
        }
        if (file == null && uri.contains("!/") && (file = StandardFileSystems.jar().findFileByPath(uri)) == null && base == null) {
            file = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file == null) {
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            if (!base.isDirectory()) {
                base = base.getParent();
            }
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            file = VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + "/" + uri);
            if (file == null) {
                return null;
            }
        }
        return file;
    }

    public static boolean processFilesRecursively(VirtualFile root, Processor<VirtualFile> processor) {
        if (!processor.process((Object)root)) {
            return false;
        }
        if (root.isDirectory()) {
            LinkedList<VirtualFile[]> queue = new LinkedList<VirtualFile[]>();
            queue.add(root.getChildren());
            do {
                VirtualFile[] files;
                for (VirtualFile file : files = (VirtualFile[])queue.removeFirst()) {
                    if (!processor.process((Object)file)) {
                        return false;
                    }
                    if (!file.isDirectory()) continue;
                    queue.add(file.getChildren());
                }
            } while (!queue.isEmpty());
        }
        return true;
    }

    public static VirtualFile getCommonAncestor(VirtualFile file1, VirtualFile file2) {
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        VirtualFile[] path1 = VfsUtilCore.getPathComponents(file1);
        VirtualFile[] path2 = VfsUtilCore.getPathComponents(file2);
        int lastEqualIdx = -1;
        int i = 0;
        while (i < path1.length && i < path2.length && path1[i].equals(path2[i])) {
            lastEqualIdx = i++;
        }
        return lastEqualIdx == -1 ? null : path1[lastEqualIdx];
    }

    static VirtualFile[] getPathComponents(VirtualFile file) {
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)componentsList.get(size - i - 1);
        }
        return components;
    }

    public static void processFilesRecursively(VirtualFile root, Processor<VirtualFile> processor, Convertor<VirtualFile, Boolean> directoryFilter) {
        if (!processor.process((Object)root)) {
            return;
        }
        if (root.isDirectory() && ((Boolean)directoryFilter.convert((Object)root)).booleanValue()) {
            LinkedList<VirtualFile[]> queue = new LinkedList<VirtualFile[]>();
            queue.add(root.getChildren());
            do {
                VirtualFile[] files;
                for (VirtualFile file : files = (VirtualFile[])queue.removeFirst()) {
                    if (!processor.process((Object)file)) {
                        return;
                    }
                    if (!file.isDirectory() || !((Boolean)directoryFilter.convert((Object)file)).booleanValue()) continue;
                    queue.add(file.getChildren());
                }
            } while (!queue.isEmpty());
        }
    }

    public static class DistinctVFilesRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public DistinctVFilesRootsCollection() {
        }

        public DistinctVFilesRootsCollection(Collection<VirtualFile> virtualFiles) {
            super(virtualFiles);
        }

        public DistinctVFilesRootsCollection(VirtualFile[] collection) {
            super((Object[])collection);
        }

        protected boolean isAncestor(VirtualFile ancestor, VirtualFile virtualFile) {
            return VfsUtilCore.isAncestor(ancestor, virtualFile, false);
        }
    }
}

