/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;

public class StandardFileSystems {
    public static final String FILE_PROTOCOL = "file";
    public static final String FILE_PROTOCOL_PREFIX = "file://";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_PROTOCOL_PREFIX = "jar://";
    public static final String JRT_PROTOCOL = "jrt";
    private static final NotNullLazyValue<VirtualFileSystem> ourLocal = new NotNullLazyValue<VirtualFileSystem>(){

        protected VirtualFileSystem compute() {
            return VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.FILE_PROTOCOL);
        }
    };
    private static final NotNullLazyValue<VirtualFileSystem> ourJar = new NotNullLazyValue<VirtualFileSystem>(){

        protected VirtualFileSystem compute() {
            return VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.JAR_PROTOCOL);
        }
    };
    public static final String JAR_SEPARATOR = "!/";
    public static final String HTTP_PROTOCOL = "http";

    public static VirtualFileSystem local() {
        return (VirtualFileSystem)ourLocal.getValue();
    }

    public static VirtualFileSystem jar() {
        return (VirtualFileSystem)ourJar.getValue();
    }

    public static VirtualFile getJarRootForLocalFile(VirtualFile virtualFile) {
        return StandardFileSystems.jar().findFileByPath(virtualFile.getPath() + JAR_SEPARATOR);
    }

    public static VirtualFile getVirtualFileForJar(VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf(JAR_SEPARATOR);
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return StandardFileSystems.local().findFileByPath(localPath);
    }
}

