/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.MergeTexts;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFilePathUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class Change {
    private int myHash;
    private final ContentRevision myBeforeRevision;
    private final ContentRevision myAfterRevision;
    private final FileStatus myFileStatus;
    protected String myMoveRelativePath;
    protected boolean myRenamed;
    protected boolean myMoved;
    protected boolean myRenameOrMoveCached = false;
    private boolean myIsReplaced;
    private Type myType;
    private final Map<String, Change> myOtherLayers;
    private Getter<MergeTexts> myMergeProvider;

    public Change(ContentRevision beforeRevision, ContentRevision afterRevision) {
        this(beforeRevision, afterRevision, Change.convertStatus(beforeRevision, afterRevision));
    }

    public Change(ContentRevision beforeRevision, ContentRevision afterRevision, FileStatus fileStatus) {
        assert (beforeRevision != null || afterRevision != null);
        this.myBeforeRevision = beforeRevision;
        this.myAfterRevision = afterRevision;
        this.myFileStatus = fileStatus == null ? Change.convertStatus(beforeRevision, afterRevision) : fileStatus;
        this.myHash = -1;
        this.myOtherLayers = new HashMap<String, Change>(0);
    }

    private static FileStatus convertStatus(ContentRevision beforeRevision, ContentRevision afterRevision) {
        if (beforeRevision == null) {
            return FileStatus.ADDED;
        }
        if (afterRevision == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    public Getter<MergeTexts> getMergeProvider() {
        return this.myMergeProvider;
    }

    public void setMergeProvider(Getter<MergeTexts> mergeProvider) {
        this.myMergeProvider = mergeProvider;
    }

    public void addAdditionalLayerElement(String name, Change change) {
        this.myOtherLayers.put(name, change);
    }

    public Map<String, Change> getOtherLayers() {
        return this.myOtherLayers;
    }

    public boolean isTreeConflict() {
        return false;
    }

    public boolean isPhantom() {
        return false;
    }

    public boolean hasOtherLayers() {
        return !this.myOtherLayers.isEmpty();
    }

    public Type getType() {
        if (this.myType == null) {
            if (this.myBeforeRevision == null) {
                this.myType = Type.NEW;
                return this.myType;
            }
            if (this.myAfterRevision == null) {
                this.myType = Type.DELETED;
                return this.myType;
            }
            if (!Comparing.equal((Object)this.myBeforeRevision.getFile(), (Object)this.myAfterRevision.getFile()) || !SystemInfo.isFileSystemCaseSensitive && VcsFilePathUtil.caseDiffers(this.myBeforeRevision.getFile().getPath(), this.myAfterRevision.getFile().getPath())) {
                this.myType = Type.MOVED;
                return this.myType;
            }
            this.myType = Type.MODIFICATION;
        }
        return this.myType;
    }

    public ContentRevision getBeforeRevision() {
        return this.myBeforeRevision;
    }

    public ContentRevision getAfterRevision() {
        return this.myAfterRevision;
    }

    public FileStatus getFileStatus() {
        return this.myFileStatus;
    }

    public VirtualFile getVirtualFile() {
        return this.myAfterRevision == null ? null : this.myAfterRevision.getFile().getVirtualFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Change)) {
            return false;
        }
        Change otherChange = (Change)o;
        ContentRevision br1 = this.getBeforeRevision();
        ContentRevision br2 = otherChange.getBeforeRevision();
        ContentRevision ar1 = this.getAfterRevision();
        ContentRevision ar2 = otherChange.getAfterRevision();
        FilePath fbr1 = br1 != null ? br1.getFile() : null;
        FilePath fbr2 = br2 != null ? br2.getFile() : null;
        FilePath far1 = ar1 != null ? ar1.getFile() : null;
        FilePath far2 = ar2 != null ? ar2.getFile() : null;
        return Comparing.equal((Object)fbr1, (Object)fbr2) && Comparing.equal((Object)far1, (Object)far2);
    }

    public int hashCode() {
        if (this.myHash == -1) {
            this.myHash = this.calculateHash();
        }
        return this.myHash;
    }

    private int calculateHash() {
        return Change.revisionHashCode(this.getBeforeRevision()) * 27 + Change.revisionHashCode(this.getAfterRevision());
    }

    private static int revisionHashCode(ContentRevision rev) {
        if (rev == null) {
            return 0;
        }
        return rev.getFile().getIOFile().getPath().hashCode();
    }

    public boolean affectsFile(File ioFile) {
        if (this.myBeforeRevision != null && this.myBeforeRevision.getFile().getIOFile().equals(ioFile)) {
            return true;
        }
        return this.myAfterRevision != null && this.myAfterRevision.getFile().getIOFile().equals(ioFile);
    }

    public boolean isRenamed() {
        this.cacheRenameOrMove(null);
        return this.myRenamed;
    }

    public boolean isMoved() {
        this.cacheRenameOrMove(null);
        return this.myMoved;
    }

    public String getMoveRelativePath(Project project) {
        this.cacheRenameOrMove(project);
        return this.myMoveRelativePath;
    }

    private void cacheRenameOrMove(Project project) {
        if (this.myBeforeRevision != null && this.myAfterRevision != null && !this.revisionPathsSame()) {
            if (!this.myRenameOrMoveCached) {
                this.myRenameOrMoveCached = true;
                if (Comparing.equal((Object)this.myBeforeRevision.getFile().getParentPath(), (Object)this.myAfterRevision.getFile().getParentPath())) {
                    this.myRenamed = true;
                } else {
                    this.myMoved = true;
                }
            }
            if (this.myMoved && this.myMoveRelativePath == null && project != null) {
                this.myMoveRelativePath = VcsPathPresenter.getInstance(project).getPresentableRelativePath(this.myBeforeRevision, this.myAfterRevision);
            }
        }
    }

    private boolean revisionPathsSame() {
        String path1 = this.myBeforeRevision.getFile().getIOFile().getAbsolutePath();
        String path2 = this.myAfterRevision.getFile().getIOFile().getAbsolutePath();
        return path1.equals(path2);
    }

    public String toString() {
        Type type = this.getType();
        switch (type) {
            case NEW: {
                return "A: " + this.myAfterRevision;
            }
            case DELETED: {
                return "D: " + this.myBeforeRevision;
            }
            case MOVED: {
                return "M: " + this.myBeforeRevision + " -> " + this.myAfterRevision;
            }
        }
        return "M: " + this.myAfterRevision;
    }

    public String getOriginText(Project project) {
        this.cacheRenameOrMove(project);
        if (this.isMoved()) {
            return this.getMovedText(project);
        }
        if (this.isRenamed()) {
            return this.getRenamedText();
        }
        return this.myIsReplaced ? VcsBundle.message("change.file.replaced.text", new Object[0]) : null;
    }

    protected String getRenamedText() {
        return VcsBundle.message("change.file.renamed.from.text", this.myBeforeRevision.getFile().getName());
    }

    protected String getMovedText(Project project) {
        return VcsBundle.message("change.file.moved.from.text", this.getMoveRelativePath(project));
    }

    public boolean isIsReplaced() {
        return this.myIsReplaced;
    }

    public void setIsReplaced(boolean isReplaced) {
        this.myIsReplaced = isReplaced;
    }

    public Icon getAdditionalIcon() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public static enum Type {
        MODIFICATION,
        NEW,
        DELETED,
        MOVED;

    }
}

