/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractVcsHelper {
    protected final Project myProject;

    protected AbstractVcsHelper(Project project) {
        this.myProject = project;
    }

    public static AbstractVcsHelper getInstance(Project project) {
        return PeriodicalTasksCloser.getInstance().safeGetService(project, AbstractVcsHelper.class);
    }

    public abstract void showErrors(List<VcsException> var1, String var2);

    public abstract void showErrors(Map<HotfixData, List<VcsException>> var1, String var2);

    public abstract List<VcsException> runTransactionRunnable(AbstractVcs var1, TransactionRunnable var2, Object var3);

    public void showError(VcsException e, String tabDisplayName) {
        this.showErrors(Arrays.asList(e), tabDisplayName);
    }

    public abstract void showAnnotation(FileAnnotation var1, VirtualFile var2, AbstractVcs var3);

    public abstract void showAnnotation(FileAnnotation var1, VirtualFile var2, AbstractVcs var3, int var4);

    public abstract void showDifferences(VcsFileRevision var1, VcsFileRevision var2, File var3);

    public abstract void showChangesListBrowser(CommittedChangeList var1, String var2);

    public void showChangesListBrowser(CommittedChangeList changelist, VirtualFile toSelect, String title) {
        this.showChangesListBrowser(changelist, title);
    }

    public abstract void showChangesBrowser(List<CommittedChangeList> var1);

    public abstract void showChangesBrowser(List<CommittedChangeList> var1, String var2);

    public abstract void showChangesBrowser(CommittedChangesProvider var1, RepositoryLocation var2, String var3, Component var4);

    public abstract void showWhatDiffersBrowser(Component var1, Collection<Change> var2, String var3);

    public abstract <T extends CommittedChangeList, U extends ChangeBrowserSettings> T chooseCommittedChangeList(CommittedChangesProvider<T, U> var1, RepositoryLocation var2);

    public abstract void openCommittedChangesTab(AbstractVcs var1, VirtualFile var2, ChangeBrowserSettings var3, int var4, String var5);

    public abstract void openCommittedChangesTab(CommittedChangesProvider var1, RepositoryLocation var2, ChangeBrowserSettings var3, int var4, String var5);

    public abstract List<VirtualFile> showMergeDialog(List<VirtualFile> var1, MergeProvider var2, MergeDialogCustomizer var3);

    public final List<VirtualFile> showMergeDialog(List<VirtualFile> files, MergeProvider provider) {
        return this.showMergeDialog(files, provider, new MergeDialogCustomizer());
    }

    public final List<VirtualFile> showMergeDialog(List<VirtualFile> files) {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        MergeProvider provider = null;
        for (VirtualFile virtualFile : files) {
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance(this.myProject).getVcsFor(virtualFile);
            if (vcs == null || (provider = vcs.getMergeProvider()) == null) continue;
            break;
        }
        if (provider == null) {
            return Collections.emptyList();
        }
        return this.showMergeDialog(files, provider);
    }

    public abstract void showFileHistory(VcsHistoryProvider var1, FilePath var2, AbstractVcs var3, String var4);

    public abstract void showFileHistory(VcsHistoryProvider var1, AnnotationProvider var2, FilePath var3, String var4, AbstractVcs var5);

    public abstract void showRollbackChangesDialog(List<Change> var1);

    public abstract Collection<VirtualFile> selectFilesToProcess(List<VirtualFile> var1, String var2, String var3, String var4, String var5, VcsShowConfirmationOption var6);

    public abstract Collection<FilePath> selectFilePathsToProcess(List<FilePath> var1, String var2, String var3, String var4, String var5, VcsShowConfirmationOption var6);

    public Collection<FilePath> selectFilePathsToProcess(List<FilePath> files, String title, String prompt, String singleFileTitle, String singleFilePromptTemplate, VcsShowConfirmationOption confirmationOption, String okActionName, String cancelActionName) {
        return this.selectFilePathsToProcess(files, title, prompt, singleFileTitle, singleFilePromptTemplate, confirmationOption);
    }

    public abstract boolean commitChanges(Collection<Change> var1, LocalChangeList var2, String var3, CommitResultHandler var4);
}

