/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class KeyedExtensionCollector<T, KeyT> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.KeyedExtensionCollector");
    private final Map<String, List<T>> myExplicitExtensions = new THashMap();
    private final ConcurrentMap<String, List<T>> myCache = ContainerUtil.newConcurrentMap();
    private final String lock;
    private ExtensionPoint<KeyedLazyInstance<T>> myPoint;
    private final String myEpName;
    private ExtensionPointAndAreaListener<KeyedLazyInstance<T>> myListener;
    private final List<ExtensionPointListener<T>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public KeyedExtensionCollector(String epName) {
        this.myEpName = epName;
        this.lock = "lock for KeyedExtensionCollector " + epName;
        this.resetAreaListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAreaListener() {
        String string = this.lock;
        synchronized (string) {
            this.myCache.clear();
            if (this.myPoint != null) {
                this.myPoint.removeExtensionPointListener(this.myListener);
                this.myPoint = null;
                this.myListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(KeyT key, T t) {
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list == null) {
                list = new ArrayList<T>();
                this.myExplicitExtensions.put(skey, list);
            }
            list.add(t);
            this.myCache.remove(skey);
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionAdded(t, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(KeyT key, T t) {
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list != null) {
                list.remove(t);
                this.myCache.remove(skey);
            }
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionRemoved(t, null);
            }
        }
    }

    protected String keyToString(KeyT key) {
        return key.toString();
    }

    public List<T> forKey(KeyT key) {
        List cached;
        String stringKey = this.keyToString(key);
        boolean rebuild = this.myPoint == null && Extensions.getRootArea().hasExtensionPoint(this.myEpName);
        List list = cached = rebuild ? null : (List)this.myCache.get(stringKey);
        if (cached != null) {
            return cached;
        }
        cached = this.buildExtensions(stringKey, key);
        cached = (List)ConcurrencyUtil.cacheOrGet(this.myCache, (Object)stringKey, cached);
        return cached;
    }

    public T findSingle(KeyT key) {
        List<T> list = this.forKey(key);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    protected List<T> buildExtensions(String stringKey, KeyT key) {
        return this.buildExtensions(Collections.singleton(stringKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<T> buildExtensions(Set<String> keys) {
        String string = this.lock;
        synchronized (string) {
            SmartList result = null;
            for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
                String key = entry.getKey();
                if (!keys.contains(key)) continue;
                List<T> list = entry.getValue();
                if (result == null) {
                    result = new ArrayList(list);
                    continue;
                }
                result.addAll(list);
            }
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            if (point != null) {
                KeyedLazyInstance[] beans;
                for (KeyedLazyInstance bean : beans = (KeyedLazyInstance[])point.getExtensions()) {
                    Object instance;
                    if (!keys.contains(bean.getKey())) continue;
                    try {
                        instance = bean.getInstance();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                        continue;
                    }
                    catch (LinkageError e) {
                        LOG.error((Throwable)e);
                        continue;
                    }
                    if (result == null) {
                        result = new SmartList();
                    }
                    result.add(instance);
                }
            }
            return result == null ? Collections.emptyList() : result;
        }
    }

    private ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        ExtensionPoint point = this.myPoint;
        if (point == null && Extensions.getRootArea().hasExtensionPoint(this.myEpName)) {
            ExtensionPointName typesafe = ExtensionPointName.create((String)this.myEpName);
            this.myPoint = point = Extensions.getRootArea().getExtensionPoint(typesafe);
            this.myListener = new ExtensionPointAndAreaListener<KeyedLazyInstance<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void extensionAdded(KeyedLazyInstance<T> bean, PluginDescriptor pluginDescriptor) {
                    String string = KeyedExtensionCollector.this.lock;
                    synchronized (string) {
                        if (bean.getKey() == null) {
                            if (pluginDescriptor != null) {
                                throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                            }
                            LOG.error("No key specified for extension of class " + bean.getInstance().getClass());
                            return;
                        }
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionAdded(bean.getInstance(), null);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void extensionRemoved(KeyedLazyInstance<T> bean, PluginDescriptor pluginDescriptor) {
                    String string = KeyedExtensionCollector.this.lock;
                    synchronized (string) {
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionRemoved(bean.getInstance(), null);
                        }
                    }
                }

                public void areaReplaced(ExtensionsArea area) {
                    KeyedExtensionCollector.this.resetAreaListener();
                }
            };
            point.addExtensionPointListener(this.myListener);
        }
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string = this.lock;
        synchronized (string) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.hasAnyExtensions();
        }
    }

    public void addListener(ExtensionPointListener<T> listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(ExtensionPointListener<T> listener) {
        this.myListeners.remove(listener);
    }
}

