/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import java.util.Collections;
import java.util.List;

public class AsyncResult<T>
extends ActionCallback {
    private static final Logger LOG = Logger.getInstance(AsyncResult.class);
    private static final AsyncResult REJECTED = new Rejected();
    private static final AsyncResult DONE_LIST = new Done<List>(Collections.EMPTY_LIST);
    protected T myResult;

    public AsyncResult() {
    }

    AsyncResult(int countToDone, T result) {
        super(countToDone);
        this.myResult = result;
    }

    public AsyncResult<T> setDone(T result) {
        this.myResult = result;
        this.setDone();
        return this;
    }

    public AsyncResult<T> setRejected(T result) {
        this.myResult = result;
        this.setRejected();
        return this;
    }

    public <DependentResult> AsyncResult<DependentResult> subResult(Function<T, DependentResult> doneHandler) {
        return this.subResult(new AsyncResult<T>(), doneHandler);
    }

    public <SubResult, SubAsyncResult extends AsyncResult<SubResult>> SubAsyncResult subResult(SubAsyncResult subResult, Function<T, SubResult> doneHandler) {
        this.doWhenDone(new SubResultDoneCallback<T, SubResult, SubAsyncResult>(subResult, doneHandler)).notifyWhenRejected(subResult);
        return subResult;
    }

    public ActionCallback subCallback(Consumer<T> doneHandler) {
        ActionCallback subCallback = new ActionCallback();
        this.doWhenDone(new SubCallbackDoneCallback<T>(subCallback, doneHandler)).notifyWhenRejected(subCallback);
        return subCallback;
    }

    @Deprecated
    public AsyncResult<T> doWhenDone(final Handler<T> handler) {
        this.doWhenDone(new Runnable(){

            @Override
            public void run() {
                handler.run(AsyncResult.this.myResult);
            }
        });
        return this;
    }

    public AsyncResult<T> doWhenDone(final Consumer<T> consumer) {
        this.doWhenDone(new Runnable(){

            @Override
            public void run() {
                consumer.consume(AsyncResult.this.myResult);
            }
        });
        return this;
    }

    @Deprecated
    public AsyncResult<T> doWhenRejected(final Handler<T> handler) {
        this.doWhenRejected(new Runnable(){

            @Override
            public void run() {
                handler.run(AsyncResult.this.myResult);
            }
        });
        return this;
    }

    public AsyncResult<T> doWhenRejected(final PairConsumer<T, String> consumer) {
        this.doWhenRejected(new Runnable(){

            @Override
            public void run() {
                consumer.consume(AsyncResult.this.myResult, (Object)AsyncResult.this.myError);
            }
        });
        return this;
    }

    @Override
    public final AsyncResult<T> notify(ActionCallback child) {
        super.notify(child);
        return this;
    }

    public T getResult() {
        return this.myResult;
    }

    public T getResultSync() {
        return this.getResultSync(-1L);
    }

    public T getResultSync(long msTimeout) {
        this.waitFor(msTimeout);
        return this.myResult;
    }

    public final ActionCallback doWhenProcessed(final Consumer<T> consumer) {
        this.doWhenDone(consumer);
        this.doWhenRejected(new PairConsumer<T, String>(){

            public void consume(T result, String error) {
                consumer.consume(result);
            }
        });
        return this;
    }

    public static <R> AsyncResult<R> rejected() {
        return REJECTED;
    }

    public static <R> AsyncResult<R> rejected(String errorMessage) {
        AsyncResult result = new AsyncResult();
        result.reject(errorMessage);
        return result;
    }

    public static <R> AsyncResult<R> done(R result) {
        return new AsyncResult<R>().setDone(result);
    }

    public static <R extends List> AsyncResult<R> doneList() {
        return DONE_LIST;
    }

    private static class SubCallbackDoneCallback<Result>
    implements Consumer<Result> {
        private final ActionCallback subResult;
        private final Consumer<Result> doneHandler;

        public SubCallbackDoneCallback(ActionCallback subResult, Consumer<Result> doneHandler) {
            this.subResult = subResult;
            this.doneHandler = doneHandler;
        }

        public void consume(Result result) {
            try {
                this.doneHandler.consume(result);
            }
            catch (Throwable e) {
                this.subResult.reject(e.getMessage());
                LOG.error(e);
                return;
            }
            this.subResult.setDone();
        }
    }

    private static class SubResultDoneCallback<Result, SubResult, AsyncSubResult extends AsyncResult<SubResult>>
    implements Consumer<Result> {
        private final AsyncSubResult subResult;
        private final Function<Result, SubResult> doneHandler;

        public SubResultDoneCallback(AsyncSubResult subResult, Function<Result, SubResult> doneHandler) {
            this.subResult = subResult;
            this.doneHandler = doneHandler;
        }

        public void consume(Result result) {
            Object v;
            try {
                v = this.doneHandler.fun(result);
            }
            catch (Throwable e) {
                ((ActionCallback)this.subResult).reject(e.getMessage());
                LOG.error(e);
                return;
            }
            ((AsyncResult)this.subResult).setDone((Object)v);
        }
    }

    public static class Rejected<T>
    extends AsyncResult<T> {
        public Rejected() {
            this.setRejected();
        }

        public Rejected(T value) {
            this.setRejected(value);
        }
    }

    public static class Done<T>
    extends AsyncResult<T> {
        public Done(T value) {
            this.setDone(value);
        }
    }

    @Deprecated
    public static interface Handler<T> {
        public void run(T var1);
    }
}

