/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExecutionCallback;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.OrderedSet;
import java.util.Set;

public class ActionCallback
implements Disposable {
    public static final ActionCallback DONE = new Done();
    public static final ActionCallback REJECTED = new Rejected();
    private final ExecutionCallback myDone;
    private final ExecutionCallback myRejected;
    protected String myError;
    private final String myName;

    public ActionCallback() {
        this(null);
    }

    public ActionCallback(String name) {
        this.myName = name;
        this.myDone = new ExecutionCallback();
        this.myRejected = new ExecutionCallback();
    }

    public ActionCallback(int countToDone) {
        this(null, countToDone);
    }

    public ActionCallback(String name, int countToDone) {
        this.myName = name;
        assert (countToDone >= 0) : "count=" + countToDone;
        int count = countToDone >= 1 ? countToDone : 1;
        this.myDone = new ExecutionCallback(count);
        this.myRejected = new ExecutionCallback();
        if (countToDone < 1) {
            this.setDone();
        }
    }

    public void setDone() {
        if (this.myDone.setExecuted()) {
            this.myRejected.clear();
            Disposer.dispose((Disposable)this);
        }
    }

    public boolean isDone() {
        return this.myDone.isExecuted();
    }

    public boolean isRejected() {
        return this.myRejected.isExecuted();
    }

    public boolean isProcessed() {
        return this.isDone() || this.isRejected();
    }

    public void setRejected() {
        if (this.myRejected.setExecuted()) {
            this.myDone.clear();
            Disposer.dispose((Disposable)this);
        }
    }

    public ActionCallback reject(String error) {
        this.myError = error;
        this.setRejected();
        return this;
    }

    public String getError() {
        return this.myError;
    }

    public final ActionCallback doWhenDone(Runnable runnable) {
        this.myDone.doWhenExecuted(runnable);
        return this;
    }

    public final ActionCallback doWhenRejected(Runnable runnable) {
        this.myRejected.doWhenExecuted(runnable);
        return this;
    }

    public final ActionCallback doWhenRejected(final Consumer<String> consumer) {
        this.myRejected.doWhenExecuted(new Runnable(){

            @Override
            public void run() {
                consumer.consume((Object)ActionCallback.this.myError);
            }
        });
        return this;
    }

    public final ActionCallback doWhenProcessed(Runnable runnable) {
        this.doWhenDone(runnable);
        this.doWhenRejected(runnable);
        return this;
    }

    public final ActionCallback notifyWhenDone(ActionCallback child) {
        return this.doWhenDone(child.createSetDoneRunnable());
    }

    public final ActionCallback notifyWhenRejected(final ActionCallback child) {
        return this.doWhenRejected(new Runnable(){

            @Override
            public void run() {
                child.reject(ActionCallback.this.myError);
            }
        });
    }

    public ActionCallback notify(ActionCallback child) {
        return this.doWhenDone(child.createSetDoneRunnable()).notifyWhenRejected(child);
    }

    public final ActionCallback processOnDone(Runnable runnable, boolean requiresDone) {
        if (requiresDone) {
            return this.doWhenDone(runnable);
        }
        runnable.run();
        return this;
    }

    public String toString() {
        String name = this.myName != null ? this.myName : super.toString();
        return name + " done=[" + this.myDone + "] rejected=[" + this.myRejected + "]";
    }

    public void dispose() {
    }

    public Runnable createSetDoneRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                ActionCallback.this.setDone();
            }
        };
    }

    @Deprecated
    public Runnable createSetRejectedRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                ActionCallback.this.setRejected();
            }
        };
    }

    public boolean waitFor(long msTimeout) {
        if (this.isProcessed()) {
            return true;
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        try {
            if (msTimeout == -1L) {
                semaphore.waitForUnsafe();
            } else if (!semaphore.waitForUnsafe(msTimeout)) {
                this.reject("Time limit exceeded");
                return false;
            }
        }
        catch (InterruptedException e) {
            this.reject(e.getMessage());
            return false;
        }
        return true;
    }

    public static class Chunk {
        private final Set<ActionCallback> myCallbacks = new OrderedSet();

        public void add(ActionCallback callback) {
            this.myCallbacks.add(callback);
        }

        public ActionCallback create() {
            if (this.isEmpty()) {
                return DONE;
            }
            ActionCallback result = new ActionCallback(this.myCallbacks.size());
            Runnable doneRunnable = result.createSetDoneRunnable();
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenDone(doneRunnable).notifyWhenRejected(result);
            }
            return result;
        }

        public boolean isEmpty() {
            return this.myCallbacks.isEmpty();
        }

        public int getSize() {
            return this.myCallbacks.size();
        }

        public ActionCallback getWhenProcessed() {
            ActionCallback result = new ActionCallback(this.myCallbacks.size());
            Runnable setDoneRunnable = result.createSetDoneRunnable();
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenProcessed(setDoneRunnable);
            }
            return result;
        }
    }

    public static class Rejected
    extends ActionCallback {
        public Rejected() {
            this.setRejected();
        }
    }

    public static class Done
    extends ActionCallback {
        public Done() {
            this.setDone();
        }
    }
}

