/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.HyperlinkListener;

public abstract class JBPopupFactory {
    public static JBPopupFactory getInstance() {
        return ServiceManager.getService(JBPopupFactory.class);
    }

    public PopupChooserBuilder createListPopupBuilder(JList list) {
        return new PopupChooserBuilder(list);
    }

    public abstract ListPopup createConfirmation(String var1, Runnable var2, int var3);

    public abstract ListPopup createConfirmation(String var1, String var2, String var3, Runnable var4, int var5);

    public abstract ListPopup createConfirmation(String var1, String var2, String var3, Runnable var4, Runnable var5, int var6);

    public abstract ListPopupStep createActionsStep(ActionGroup var1, DataContext var2, boolean var3, boolean var4, String var5, Component var6, boolean var7);

    public abstract ListPopupStep createActionsStep(ActionGroup var1, DataContext var2, boolean var3, boolean var4, String var5, Component var6, boolean var7, int var8, boolean var9);

    public abstract RelativePoint guessBestPopupLocation(JComponent var1);

    public boolean isChildPopupFocused(Component parent) {
        return this.getChildFocusedPopup(parent) != null;
    }

    public JBPopup getChildFocusedPopup(Component parent) {
        if (parent == null) {
            return null;
        }
        List<JBPopup> popups = this.getChildPopups(parent);
        for (JBPopup each : popups) {
            if (each.isFocused()) {
                return each;
            }
            JBPopup childFocusedPopup = this.getChildFocusedPopup(each.getContent());
            if (childFocusedPopup == null) continue;
            return childFocusedPopup;
        }
        return null;
    }

    public abstract ListPopup createActionGroupPopup(String var1, ActionGroup var2, DataContext var3, ActionSelectionAid var4, boolean var5);

    public abstract ListPopup createActionGroupPopup(String var1, ActionGroup var2, DataContext var3, ActionSelectionAid var4, boolean var5, String var6);

    public abstract ListPopup createActionGroupPopup(String var1, ActionGroup var2, DataContext var3, ActionSelectionAid var4, boolean var5, Runnable var6, int var7);

    public abstract ListPopup createActionGroupPopup(String var1, ActionGroup var2, DataContext var3, boolean var4, boolean var5, boolean var6, Runnable var7, int var8, Condition<AnAction> var9);

    public abstract ListPopup createWizardStep(PopupStep var1);

    public abstract ListPopup createListPopup(ListPopupStep var1);

    public abstract ListPopup createListPopup(ListPopupStep var1, int var2);

    public abstract TreePopup createTree(JBPopup var1, TreePopupStep var2, Object var3);

    public abstract TreePopup createTree(TreePopupStep var1);

    public abstract ComponentPopupBuilder createComponentPopupBuilder(JComponent var1, JComponent var2);

    public abstract RelativePoint guessBestPopupLocation(DataContext var1);

    public abstract RelativePoint guessBestPopupLocation(Editor var1);

    public abstract boolean isBestPopupLocationVisible(Editor var1);

    public abstract Point getCenterOf(JComponent var1, JComponent var2);

    public abstract List<JBPopup> getChildPopups(Component var1);

    public abstract boolean isPopupActive();

    public abstract BalloonBuilder createBalloonBuilder(JComponent var1);

    public abstract BalloonBuilder createDialogBalloonBuilder(JComponent var1, String var2);

    public abstract BalloonBuilder createHtmlTextBalloonBuilder(String var1, Icon var2, Color var3, HyperlinkListener var4);

    public abstract BalloonBuilder createHtmlTextBalloonBuilder(String var1, MessageType var2, HyperlinkListener var3);

    public abstract JBPopup createMessage(String var1);

    public abstract Balloon getParentBalloonFor(Component var1);

    public static enum ActionSelectionAid {
        NUMBERING,
        ALPHA_NUMBERING,
        SPEEDSEARCH,
        MNEMONICS;

    }
}

