/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import java.util.LinkedHashMap;
import java.util.Map;

public interface Queryable {
    public void putInfo(Map<String, String> var1);

    public static interface Contributor {
        public void apply(Map<String, String> var1);
    }

    public static class Util {
        public static String print(Queryable ui, PrintInfo printInfo, Contributor contributor) {
            PrintInfo print = printInfo != null ? printInfo : new PrintInfo();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            ui.putInfo(map);
            if (contributor != null) {
                contributor.apply(map);
            }
            String id = null;
            if (!map.isEmpty()) {
                id = map.values().iterator().next();
            }
            StringBuilder info = new StringBuilder();
            if (print.myInfoKeys != null) {
                for (String eachKey : print.myInfoKeys) {
                    String eachValue = map.get(eachKey);
                    if (eachValue == null) continue;
                    if (info.length() > 0) {
                        info.append(",");
                    }
                    info.append(eachKey).append("=").append(eachValue);
                }
            }
            return id + (info.length() > 0 ? " " + info.toString() : "");
        }

        public static String print(Queryable ui, PrintInfo printInfo) {
            return Util.print(ui, printInfo, null);
        }
    }

    public static class PrintInfo {
        private final String[] myIdKeys;
        private final String[] myInfoKeys;

        public PrintInfo() {
            this(null, null);
        }

        public PrintInfo(String[] idKeys) {
            this(idKeys, null);
        }

        public PrintInfo(String[] idKeys, String[] infoKeys) {
            this.myIdKeys = idKeys;
            this.myInfoKeys = infoKeys;
        }
    }
}

