/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.io.File;

public class LightFilePointer
implements VirtualFilePointer {
    private final String myUrl;
    private VirtualFile myFile;

    public LightFilePointer(String url) {
        this.myUrl = url;
    }

    public LightFilePointer(VirtualFile file) {
        this.myUrl = file.getUrl();
        this.myFile = file;
    }

    @Override
    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @Override
    public String getUrl() {
        return this.myUrl;
    }

    @Override
    public String getFileName() {
        if (this.myFile != null) {
            return this.myFile.getName();
        }
        int index = this.myUrl.lastIndexOf(47);
        return index >= 0 ? this.myUrl.substring(index + 1) : this.myUrl;
    }

    @Override
    public String getPresentableUrl() {
        VirtualFile file = this.getFile();
        if (file != null) {
            return file.getPresentableUrl();
        }
        return LightFilePointer.toPresentableUrl(this.myUrl);
    }

    public static String toPresentableUrl(String url) {
        String path = VirtualFileManager.extractPath(url);
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        return path.replace('/', File.separatorChar);
    }

    @Override
    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        if (this.myFile != null && this.myFile.isValid()) {
            return;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        this.myFile = virtualFile != null && virtualFile.isValid() ? virtualFile : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LightFilePointer)) {
            return false;
        }
        return this.myUrl.equals(((LightFilePointer)o).myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }
}

