/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import java.util.HashMap;
import java.util.Map;

public class LibraryKind {
    private final String myKindId;
    private static final Map<String, LibraryKind> ourAllKinds = new HashMap<String, LibraryKind>();

    public LibraryKind(String kindId) {
        this.myKindId = kindId;
        if (ourAllKinds.containsKey(kindId)) {
            throw new IllegalArgumentException("Kind " + kindId + " is not unique");
        }
        ourAllKinds.put(kindId, this);
    }

    public final String getKindId() {
        return this.myKindId;
    }

    public String toString() {
        return "LibraryKind:" + this.myKindId;
    }

    public static LibraryKind create(String kindId) {
        return new LibraryKind(kindId);
    }

    public static LibraryKind findById(String kindId) {
        return ourAllKinds.get(kindId);
    }
}

