/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ProjectRootManager
extends SimpleModificationTracker {
    public static ProjectRootManager getInstance(Project project) {
        ProjectRootManager service = ServiceManager.getService(project, ProjectRootManager.class);
        if (service != null) {
            return service;
        }
        return project.getComponent(ProjectRootManager.class);
    }

    public abstract ProjectFileIndex getFileIndex();

    public abstract OrderEnumerator orderEntries();

    public abstract OrderEnumerator orderEntries(Collection<? extends Module> var1);

    public abstract VirtualFile[] getContentRootsFromAllModules();

    public abstract List<String> getContentRootUrls();

    public abstract VirtualFile[] getContentRoots();

    public abstract VirtualFile[] getContentSourceRoots();

    public abstract List<VirtualFile> getModuleSourceRoots(Set<? extends JpsModuleSourceRootType<?>> var1);

    public abstract Sdk getProjectSdk();

    public abstract String getProjectSdkName();

    public abstract void setProjectSdk(Sdk var1);

    public abstract void setProjectSdkName(String var1);
}

