/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.PathUtil;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JdkUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.JdkUtil");
    private static final String WRAPPER_CLASS = "com.intellij.rt.execution.CommandLineWrapper";

    private JdkUtil() {
    }

    public static String getJdkMainAttribute(Sdk jdk, Attributes.Name attribute) {
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile rtJar = homeDirectory.findFileByRelativePath("jre/lib/rt.jar");
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("lib/rt.jar");
        }
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("jre/lib/vm.jar");
        }
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("../Classes/classes.jar");
        }
        if (rtJar == null) {
            String versionString = jdk.getVersionString();
            if (versionString != null) {
                int start = versionString.indexOf("\"");
                int end = versionString.lastIndexOf("\"");
                versionString = start >= 0 && end > start ? versionString.substring(start + 1, end) : null;
            }
            return versionString;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(rtJar);
        return jarRoot != null ? JdkUtil.getJarMainAttribute(jarRoot, attribute) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJarMainAttribute(VirtualFile jarRoot, Attributes.Name attribute) {
        VirtualFile manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifestFile != null) {
            String string;
            InputStream stream = manifestFile.getInputStream();
            try {
                string = new Manifest(stream).getMainAttributes().getValue(attribute);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            stream.close();
            return string;
        }
        return null;
    }

    public static boolean checkForJdk(String homePath) {
        return JdkUtil.checkForJdk(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJdk(File homePath) {
        File binPath = new File(homePath, "bin");
        if (!binPath.exists()) {
            return false;
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                String name = FileUtil.getNameWithoutExtension((File)f);
                return "javac".equals(name) || "javah".equals(name);
            }
        };
        File[] children = binPath.listFiles(fileFilter);
        return children != null && children.length >= 2 && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForJre(String homePath) {
        return JdkUtil.checkForJre(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJre(File homePath) {
        File binPath = new File(homePath, "bin");
        if (!binPath.exists()) {
            return false;
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory() && "java".equals(FileUtil.getNameWithoutExtension((File)f));
            }
        };
        File[] children = binPath.listFiles(fileFilter);
        return children != null && children.length >= 1 && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForRuntime(String homePath) {
        return new File(homePath, "jre/lib/rt.jar").exists() || new File(homePath, "lib/rt.jar").exists() || new File(homePath, "lib/modules").exists() || new File(homePath, "../Classes/classes.jar").exists() || new File(homePath, "jre/lib/vm.jar").exists() || new File(homePath, "classes").isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(exePath);
        ParametersList vmParametersList = javaParameters.getVMParametersList();
        commandLine.getEnvironment().putAll(javaParameters.getEnv());
        commandLine.setPassParentEnvironment(javaParameters.isPassParentEnvs());
        Class commandLineWrapper = JdkUtil.getCommandLineWrapperClass();
        if (commandLineWrapper != null) {
            if (forceDynamicClasspath) {
                File classpathFile = null;
                File vmParamsFile = null;
                if (!vmParametersList.hasParameter("-classpath") && !vmParametersList.hasParameter("-cp")) {
                    PrintWriter writer;
                    if (javaParameters.isDynamicVMOptions() && JdkUtil.useDynamicVMOptions()) {
                        try {
                            vmParamsFile = FileUtil.createTempFile((String)"vm_params", null);
                            writer = new PrintWriter(vmParamsFile);
                            try {
                                for (String param : vmParametersList.getList()) {
                                    if (!param.startsWith("-D")) continue;
                                    writer.println(param);
                                }
                            }
                            finally {
                                writer.close();
                            }
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                        List<String> list = vmParametersList.getList();
                        for (String param : list) {
                            if (param.trim().startsWith("-D")) continue;
                            commandLine.addParameter(param);
                        }
                    } else {
                        commandLine.addParameters(vmParametersList.getList());
                    }
                    try {
                        Class<UrlClassLoader> ourUrlClassLoader;
                        String utilRtPath;
                        classpathFile = FileUtil.createTempFile((String)"classpath", null);
                        writer = new PrintWriter(classpathFile);
                        try {
                            for (String path : javaParameters.getClassPath().getPathList()) {
                                writer.println(path);
                            }
                        }
                        finally {
                            writer.close();
                        }
                        String classpath = PathUtil.getJarPathForClass(commandLineWrapper);
                        if (!classpath.equals(utilRtPath = PathUtil.getJarPathForClass(StringUtilRt.class))) {
                            classpath = classpath + File.pathSeparator + utilRtPath;
                        }
                        if ((ourUrlClassLoader = UrlClassLoader.class).getName().equals(vmParametersList.getPropertyValue("java.system.class.loader"))) {
                            classpath = classpath + File.pathSeparator + PathUtil.getJarPathForClass(ourUrlClassLoader);
                            classpath = classpath + File.pathSeparator + PathUtil.getJarPathForClass(THashMap.class);
                        }
                        commandLine.addParameter("-classpath");
                        commandLine.addParameter(classpath);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                JdkUtil.appendEncoding(javaParameters, commandLine, vmParametersList);
                if (classpathFile != null) {
                    commandLine.addParameter(commandLineWrapper.getName());
                    commandLine.addParameter(classpathFile.getAbsolutePath());
                }
                if (vmParamsFile != null) {
                    commandLine.addParameter("@vm_params");
                    commandLine.addParameter(vmParamsFile.getAbsolutePath());
                }
            } else {
                JdkUtil.appendParamsEncodingClasspath(javaParameters, commandLine, vmParametersList);
            }
        } else {
            JdkUtil.appendParamsEncodingClasspath(javaParameters, commandLine, vmParametersList);
        }
        String mainClass = javaParameters.getMainClass();
        String jarPath = javaParameters.getJarPath();
        if (mainClass != null) {
            commandLine.addParameter(mainClass);
        } else if (jarPath != null) {
            commandLine.addParameter("-jar");
            commandLine.addParameter(jarPath);
        }
        commandLine.addParameters(javaParameters.getProgramParametersList().getList());
        commandLine.withWorkDirectory(javaParameters.getWorkingDirectory());
        return commandLine;
    }

    private static void appendParamsEncodingClasspath(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList parametersList) {
        commandLine.addParameters(parametersList.getList());
        JdkUtil.appendEncoding(javaParameters, commandLine, parametersList);
        if (!(parametersList.hasParameter("-classpath") || parametersList.hasParameter("-cp") || javaParameters.getClassPath().getPathList().isEmpty())) {
            commandLine.addParameter("-classpath");
            commandLine.addParameter(javaParameters.getClassPath().getPathsString());
        }
    }

    private static void appendEncoding(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList parametersList) {
        String encoding = parametersList.getPropertyValue("file.encoding");
        if (encoding == null) {
            Charset charset = javaParameters.getCharset();
            if (charset == null) {
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            commandLine.addParameter("-Dfile.encoding=" + charset.name());
            commandLine.withCharset(charset);
        } else {
            try {
                Charset charset = Charset.forName(encoding);
                commandLine.withCharset(charset);
            }
            catch (UnsupportedCharsetException ignore) {
            }
            catch (IllegalCharsetNameException ignore) {
                // empty catch block
            }
        }
    }

    private static Class getCommandLineWrapperClass() {
        try {
            return Class.forName(WRAPPER_CLASS);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean useDynamicClasspath(Project project) {
        String hasDynamicProperty = System.getProperty("idea.dynamic.classpath", "false");
        return Boolean.valueOf(project != null ? PropertiesComponent.getInstance(project).getOrInit("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty);
    }

    public static boolean useDynamicVMOptions() {
        return Boolean.valueOf(PropertiesComponent.getInstance().getOrInit("dynamic.vmoptions", "true"));
    }
}

