/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.pom.java.LanguageLevel;
import java.util.Arrays;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3, "1.0"),
    JDK_1_1(LanguageLevel.JDK_1_3, "1.1"),
    JDK_1_2(LanguageLevel.JDK_1_3, "1.2"),
    JDK_1_3(LanguageLevel.JDK_1_3, "1.3"),
    JDK_1_4(LanguageLevel.JDK_1_4, "1.4"),
    JDK_1_5(LanguageLevel.JDK_1_5, "1.5"),
    JDK_1_6(LanguageLevel.JDK_1_6, "1.6"),
    JDK_1_7(LanguageLevel.JDK_1_7, "1.7"),
    JDK_1_8(LanguageLevel.JDK_1_8, "1.8"),
    JDK_1_9(LanguageLevel.JDK_1_9, "1.9");

    private final LanguageLevel myMaxLanguageLevel;
    private final String myDescription;

    private JavaSdkVersion(LanguageLevel maxLanguageLevel, String description) {
        this.myMaxLanguageLevel = maxLanguageLevel;
        this.myDescription = description;
    }

    public LanguageLevel getMaxLanguageLevel() {
        return this.myMaxLanguageLevel;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public boolean isAtLeast(JavaSdkVersion version) {
        return this.compareTo(version) >= 0;
    }

    public String toString() {
        return super.toString() + ", description: " + this.myDescription;
    }

    public static JavaSdkVersion byDescription(String description) throws IllegalArgumentException {
        for (JavaSdkVersion version : JavaSdkVersion.values()) {
            if (!version.getDescription().equals(description)) continue;
            return version;
        }
        throw new IllegalArgumentException(String.format("Can't map Java SDK by description (%s). Available values: %s", description, Arrays.toString((Object[])JavaSdkVersion.values())));
    }

    public static JavaSdkVersion fromLanguageLevel(LanguageLevel languageLevel) throws IllegalArgumentException {
        JavaSdkVersion[] values = JavaSdkVersion.values();
        for (int i = values.length - 1; i >= 0; --i) {
            JavaSdkVersion version = values[i];
            if (!version.getMaxLanguageLevel().isAtLeast(languageLevel)) continue;
            return version;
        }
        throw new IllegalArgumentException("Can't map Java SDK by language level " + (Object)((Object)languageLevel) + ". Available values: " + Arrays.toString((Object[])JavaSdkVersion.values()));
    }
}

