/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import javax.swing.Icon;

public class PathReference {
    public static final NullableFunction<PathReference, Icon> NULL_ICON = new NullableConstantFunction((Object)null);
    private final String myPath;
    private final NullableLazyValue<Icon> myIcon;

    public PathReference(String path, final Function<PathReference, Icon> icon) {
        this.myPath = path;
        this.myIcon = new NullableLazyValue<Icon>(){

            protected Icon compute() {
                return (Icon)icon.fun((Object)PathReference.this);
            }
        };
    }

    public String getPath() {
        return this.myPath;
    }

    public String getTrimmedPath() {
        return PathReference.trimPath(this.myPath);
    }

    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    public PsiElement resolve() {
        return null;
    }

    public static String trimPath(String url) {
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    return url.substring(0, i);
                }
            }
        }
        return url;
    }

    public static class ResolveFunction
    implements NullableFunction<PathReference, Icon> {
        public static final ResolveFunction NULL_RESOLVE_FUNCTION = new ResolveFunction(null);
        private final Icon myDefaultIcon;

        public ResolveFunction(Icon defaultValue) {
            this.myDefaultIcon = defaultValue;
        }

        public Icon fun(PathReference pathReference) {
            PsiElement element = pathReference.resolve();
            return element == null ? this.myDefaultIcon : element.getIcon(2);
        }
    }
}

