/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.HashSet;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ModuleUtilCore {
    public static final Key<Module> KEY_MODULE = new Key("Module");

    public static boolean projectContainsFile(Project project, VirtualFile file, boolean isLibraryElement) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (isLibraryElement) {
            List<OrderEntry> orders = projectFileIndex.getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orders) {
                if (!(orderEntry instanceof ModuleJdkOrderEntry) && !(orderEntry instanceof JdkOrderEntry) && !(orderEntry instanceof LibraryOrderEntry)) continue;
                return true;
            }
            return false;
        }
        return projectFileIndex.isInContent(file);
    }

    public static String getModuleNameInReadAction(final Module module) {
        return (String)new ReadAction<String>(){

            @Override
            protected void run(Result<String> result) throws Throwable {
                result.setResult(module.getName());
            }
        }.execute().getResultObject();
    }

    public static boolean isModuleDisposed(PsiElement element) {
        Module module;
        if (!element.isValid()) {
            return true;
        }
        Project project = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return true;
        }
        VirtualFile vFile = file.getVirtualFile();
        Module module2 = module = vFile == null ? null : projectFileIndex.getModuleForFile(vFile);
        return module == null ? !projectFileIndex.isInLibraryClasses(vFile) : module.isDisposed();
    }

    public static Module findModuleForFile(VirtualFile file, Project project) {
        return ProjectFileIndex.SERVICE.getInstance(project).getModuleForFile(file);
    }

    public static Module findModuleForPsiElement(PsiElement element) {
        if (!element.isValid()) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null && !containingFile.isValid()) {
            return null;
        }
        Project project = (containingFile == null ? element : containingFile).getProject();
        if (project.isDefault()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (element instanceof PsiFileSystemItem && (!(element instanceof PsiFile) || element.getContext() == null)) {
            VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (vFile == null) {
                VirtualFile virtualFile = vFile = containingFile == null ? null : containingFile.getOriginalFile().getVirtualFile();
                if (vFile == null) {
                    return (Module)element.getUserData(KEY_MODULE);
                }
            }
            if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
                List<OrderEntry> orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return null;
                }
                if (orderEntries.size() == 1) {
                    return orderEntries.get(0).getOwnerModule();
                }
                HashSet modules = new HashSet();
                for (OrderEntry orderEntry : orderEntries) {
                    modules.add(orderEntry.getOwnerModule());
                }
                Module[] candidates = modules.toArray(new Module[modules.size()]);
                Arrays.sort(candidates, ModuleManager.getInstance(project).moduleDependencyComparator());
                return candidates[0];
            }
            return fileIndex.getModuleForFile(vFile);
        }
        if (containingFile != null) {
            PsiFile file;
            PsiElement context;
            while ((context = containingFile.getContext()) != null && (file = context.getContainingFile()) != null) {
                containingFile = file;
            }
            if (containingFile.getUserData(KEY_MODULE) != null) {
                return (Module)containingFile.getUserData(KEY_MODULE);
            }
            PsiFile originalFile = containingFile.getOriginalFile();
            if (originalFile.getUserData(KEY_MODULE) != null) {
                return (Module)originalFile.getUserData(KEY_MODULE);
            }
            VirtualFile virtualFile = originalFile.getVirtualFile();
            if (virtualFile != null) {
                return fileIndex.getModuleForFile(virtualFile);
            }
        }
        return (Module)element.getUserData(KEY_MODULE);
    }

    public static void getDependencies(Module module, Set<Module> modules) {
        Module[] dependencies;
        if (modules.contains(module)) {
            return;
        }
        modules.add(module);
        for (Module dependency : dependencies = ModuleRootManager.getInstance(module).getDependencies()) {
            ModuleUtilCore.getDependencies(dependency, modules);
        }
    }

    public static void collectModulesDependsOn(Module module, Set<Module> result) {
        if (result.contains(module)) {
            return;
        }
        result.add(module);
        ModuleManager moduleManager = ModuleManager.getInstance(module.getProject());
        List<Module> dependentModules = moduleManager.getModuleDependentModules(module);
        block0: for (Module dependentModule : dependentModules) {
            OrderEntry[] orderEntries;
            for (OrderEntry o : orderEntries = ModuleRootManager.getInstance(dependentModule).getOrderEntries()) {
                ModuleOrderEntry orderEntry;
                if (!(o instanceof ModuleOrderEntry) || (orderEntry = (ModuleOrderEntry)o).getModule() != module) continue;
                if (orderEntry.isExported()) {
                    ModuleUtilCore.collectModulesDependsOn(dependentModule, result);
                    continue block0;
                }
                result.add(dependentModule);
                continue block0;
            }
        }
    }

    public static List<Module> getAllDependentModules(Module module) {
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = ModuleManager.getInstance(module.getProject()).moduleGraph();
        Iterator i = graph.getOut((Object)module);
        while (i.hasNext()) {
            list.add((Module)i.next());
        }
        return list;
    }

    public static boolean visitMeAndDependentModules(Module module, ModuleVisitor visitor) {
        if (!visitor.visit(module)) {
            return false;
        }
        List<Module> list = ModuleUtilCore.getAllDependentModules(module);
        for (Module dependentModule : list) {
            if (visitor.visit(dependentModule)) continue;
            return false;
        }
        return true;
    }

    public static boolean moduleContainsFile(Module module, VirtualFile file, boolean isLibraryElement) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        if (isLibraryElement) {
            OrderEntry orderEntry = moduleRootManager.getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof ModuleJdkOrderEntry || orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }
        return moduleRootManager.getFileIndex().isInContent(file);
    }

    public static interface ModuleVisitor {
        public boolean visit(Module var1);
    }
}

