/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.MockFileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public abstract class FileTypeManager
extends FileTypeRegistry {
    private static FileTypeManager ourInstance;
    public static final Topic<FileTypeListener> TOPIC;

    public static FileTypeManager getInstance() {
        FileTypeManager instance = ourInstance;
        if (instance == null) {
            Application app = ApplicationManager.getApplication();
            instance = app != null ? app.getComponent(FileTypeManager.class) : new MockFileTypeManager();
            ourInstance = instance;
        }
        return instance;
    }

    public abstract void registerFileType(FileType var1, List<FileNameMatcher> var2);

    public final void registerFileType(FileType type, String ... defaultAssociatedExtensions) {
        ArrayList<FileNameMatcher> matchers = new ArrayList<FileNameMatcher>();
        if (defaultAssociatedExtensions != null) {
            for (String extension : defaultAssociatedExtensions) {
                matchers.add(new ExtensionFileNameMatcher(extension));
            }
        }
        this.registerFileType(type, matchers);
    }

    public abstract boolean isFileIgnored(String var1);

    public abstract String[] getAssociatedExtensions(FileType var1);

    public abstract List<FileNameMatcher> getAssociations(FileType var1);

    public abstract boolean isFileOfType(VirtualFile var1, FileType var2);

    public abstract void addFileTypeListener(FileTypeListener var1);

    public abstract void removeFileTypeListener(FileTypeListener var1);

    @Deprecated
    public abstract FileType getKnownFileTypeOrAssociate(VirtualFile var1);

    public abstract FileType getKnownFileTypeOrAssociate(VirtualFile var1, Project var2);

    public abstract String getIgnoredFilesList();

    public abstract void setIgnoredFilesList(String var1);

    public final void associateExtension(FileType type, String extension) {
        this.associate(type, new ExtensionFileNameMatcher(extension));
    }

    public final void associatePattern(FileType type, String pattern) {
        this.associate(type, FileTypeManager.parseFromString(pattern));
    }

    public abstract void associate(FileType var1, FileNameMatcher var2);

    public final void removeAssociatedExtension(FileType type, String extension) {
        this.removeAssociation(type, new ExtensionFileNameMatcher(extension));
    }

    public abstract void removeAssociation(FileType var1, FileNameMatcher var2);

    public static FileNameMatcher parseFromString(String pattern) {
        return FileNameMatcherFactory.getInstance().createMatcher(pattern);
    }

    public abstract FileType getStdFileType(String var1);

    static {
        FileTypeRegistry.ourInstanceGetter = new Getter<FileTypeRegistry>(){

            public FileTypeRegistry get() {
                return FileTypeManager.getInstance();
            }
        };
        ourInstance = CachedSingletonsRegistry.markCachedField(FileTypeManager.class);
        TOPIC = new Topic("File types change", FileTypeListener.class);
    }
}

