/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;

public class FileTypeEditorHighlighterProviders
extends FileTypeExtension<EditorHighlighterProvider> {
    public static final FileTypeEditorHighlighterProviders INSTANCE = new FileTypeEditorHighlighterProviders();

    private FileTypeEditorHighlighterProviders() {
        super("com.intellij.editorHighlighterProvider");
    }

    @Override
    protected List<EditorHighlighterProvider> buildExtensions(String stringKey, FileType key) {
        List<EditorHighlighterProvider> fromEP = super.buildExtensions(stringKey, key);
        if (fromEP.isEmpty()) {
            EditorHighlighterProvider defaultProvider = new EditorHighlighterProvider(){

                @Override
                public EditorHighlighter getEditorHighlighter(Project project, FileType fileType, VirtualFile virtualFile, EditorColorsScheme colors) {
                    return EditorHighlighterFactory.getInstance().createEditorHighlighter(SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, virtualFile), colors);
                }
            };
            return Collections.singletonList(defaultProvider);
        }
        return fromEP;
    }
}

