/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.DataManager;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import java.util.List;

public class OpenFileDescriptor
implements Navigatable {
    public static final DataKey<Editor> NAVIGATE_IN_EDITOR = DataKey.create("NAVIGATE_IN_EDITOR");
    private final Project myProject;
    private final VirtualFile myFile;
    private final int myLogicalLine;
    private final int myLogicalColumn;
    private final int myOffset;
    private final RangeMarker myRangeMarker;
    private boolean myUseCurrentWindow = false;

    public OpenFileDescriptor(Project project, VirtualFile file, int offset) {
        this(project, file, -1, -1, offset, false);
    }

    public OpenFileDescriptor(Project project, VirtualFile file, int logicalLine, int logicalColumn) {
        this(project, file, logicalLine, logicalColumn, -1, false);
    }

    public OpenFileDescriptor(Project project, VirtualFile file, int logicalLine, int logicalColumn, boolean persistent) {
        this(project, file, logicalLine, logicalColumn, -1, persistent);
    }

    public OpenFileDescriptor(Project project, VirtualFile file) {
        this(project, file, -1, -1, -1, false);
    }

    private OpenFileDescriptor(Project project, VirtualFile file, int logicalLine, int logicalColumn, int offset, boolean persistent) {
        this.myProject = project;
        this.myFile = file;
        this.myLogicalLine = logicalLine;
        this.myLogicalColumn = logicalColumn;
        this.myOffset = offset;
        this.myRangeMarker = offset >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, offset) : (logicalLine >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, logicalLine, Math.max(0, logicalColumn), persistent) : null);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    public int getOffset() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid() ? this.myRangeMarker.getStartOffset() : this.myOffset;
    }

    public int getLine() {
        return this.myLogicalLine;
    }

    public int getColumn() {
        return this.myLogicalColumn;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (!this.canNavigate()) {
            throw new IllegalStateException("Navigation is not possible with null project");
        }
        if (!this.myFile.isDirectory() && this.navigateInEditorOrNativeApp(this.myProject, requestFocus)) {
            return;
        }
        this.navigateInProjectView(requestFocus);
    }

    private boolean navigateInEditorOrNativeApp(Project project, boolean requestFocus) {
        FileType type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(this.myFile, project);
        if (type == null || !this.myFile.isValid()) {
            return false;
        }
        if (type instanceof INativeFileType) {
            return ((INativeFileType)type).openFileInAssociatedApplication(project, this.myFile);
        }
        return this.navigateInEditor(project, requestFocus);
    }

    public boolean navigateInEditor(Project project, boolean requestFocus) {
        return this.navigateInRequestedEditor() || this.navigateInAnyFileEditor(project, requestFocus);
    }

    private boolean navigateInRequestedEditor() {
        DataContext ctx = DataManager.getInstance().getDataContext();
        Editor e = NAVIGATE_IN_EDITOR.getData(ctx);
        if (e == null) {
            return false;
        }
        if (!Comparing.equal((Object)FileDocumentManager.getInstance().getFile(e.getDocument()), (Object)this.myFile)) {
            return false;
        }
        this.navigateIn(e);
        return true;
    }

    private boolean navigateInAnyFileEditor(Project project, boolean focusEditor) {
        List<FileEditor> editors = FileEditorManager.getInstance(project).openEditor(this, focusEditor);
        for (FileEditor editor : editors) {
            if (!(editor instanceof TextEditor)) continue;
            Editor e = ((TextEditor)editor).getEditor();
            OpenFileDescriptor.unfoldCurrentLine(e);
            if (!focusEditor) continue;
            IdeFocusManager.getInstance(this.myProject).requestFocus(e.getContentComponent(), true);
        }
        return !editors.isEmpty();
    }

    private void navigateInProjectView(boolean requestFocus) {
        SelectInContext context = new SelectInContext(){

            @Override
            public Project getProject() {
                return OpenFileDescriptor.this.myProject;
            }

            @Override
            public VirtualFile getVirtualFile() {
                return OpenFileDescriptor.this.myFile;
            }

            @Override
            public Object getSelectorInFile() {
                return null;
            }

            @Override
            public FileEditorProvider getFileEditorProvider() {
                return null;
            }
        };
        for (SelectInTarget target : SelectInManager.getInstance(this.myProject).getTargets()) {
            if (!target.canSelect(context)) continue;
            target.selectIn(context, requestFocus);
            return;
        }
    }

    public void navigateIn(Editor e) {
        int offset = this.getOffset();
        CaretModel caretModel = e.getCaretModel();
        boolean caretMoved = false;
        if (this.myLogicalLine >= 0) {
            LogicalPosition pos = new LogicalPosition(this.myLogicalLine, Math.max(this.myLogicalColumn, 0));
            if (offset < 0 || offset == e.logicalPositionToOffset(pos)) {
                caretModel.removeSecondaryCarets();
                caretModel.moveToLogicalPosition(pos);
                caretMoved = true;
            }
        }
        if (!caretMoved && offset >= 0) {
            caretModel.removeSecondaryCarets();
            caretModel.moveToOffset(Math.min(offset, e.getDocument().getTextLength()));
            caretMoved = true;
        }
        if (caretMoved) {
            e.getSelectionModel().removeSelection();
            OpenFileDescriptor.scrollToCaret(e);
            OpenFileDescriptor.unfoldCurrentLine(e);
        }
    }

    private static void unfoldCurrentLine(Editor editor) {
        final FoldRegion[] allRegions = editor.getFoldingModel().getAllFoldRegions();
        final TextRange range = OpenFileDescriptor.getRangeToUnfoldOnNavigation(editor);
        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                for (FoldRegion region : allRegions) {
                    if (region.isExpanded() || !range.intersects(TextRange.create((Segment)region))) continue;
                    region.setExpanded(true);
                }
            }
        });
    }

    public static TextRange getRangeToUnfoldOnNavigation(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        int line = editor.getDocument().getLineNumber(offset);
        int start = editor.getDocument().getLineStartOffset(line);
        int end = editor.getDocument().getLineEndOffset(line);
        return new TextRange(start, end);
    }

    private static void scrollToCaret(Editor e) {
        e.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    @Override
    public boolean canNavigate() {
        return this.myFile.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public Project getProject() {
        return this.myProject;
    }

    public OpenFileDescriptor setUseCurrentWindow(boolean search) {
        this.myUseCurrentWindow = search;
        return this;
    }

    public boolean isUseCurrentWindow() {
        return this.myUseCurrentWindow;
    }

    public void dispose() {
        if (this.myRangeMarker != null) {
            this.myRangeMarker.dispose();
        }
    }
}

