/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;

public abstract class FileEditorManager {
    public static final Key<Boolean> USE_CURRENT_WINDOW = Key.create((String)"OpenFile.searchForOpen");

    public static FileEditorManager getInstance(Project project) {
        return project.getComponent(FileEditorManager.class);
    }

    public abstract FileEditor[] openFile(VirtualFile var1, boolean var2);

    public FileEditor[] openFile(VirtualFile file, boolean focusEditor, boolean searchForOpen) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract void closeFile(VirtualFile var1);

    public abstract Editor openTextEditor(OpenFileDescriptor var1, boolean var2);

    public abstract Editor getSelectedTextEditor();

    public abstract boolean isFileOpen(VirtualFile var1);

    public abstract VirtualFile[] getOpenFiles();

    public abstract VirtualFile[] getSelectedFiles();

    public abstract FileEditor[] getSelectedEditors();

    public abstract FileEditor getSelectedEditor(VirtualFile var1);

    public abstract FileEditor[] getEditors(VirtualFile var1);

    public abstract FileEditor[] getAllEditors(VirtualFile var1);

    public abstract FileEditor[] getAllEditors();

    public abstract void showEditorAnnotation(FileEditor var1, JComponent var2);

    public abstract void removeEditorAnnotation(FileEditor var1, JComponent var2);

    public abstract void addTopComponent(FileEditor var1, JComponent var2);

    public abstract void removeTopComponent(FileEditor var1, JComponent var2);

    public abstract void addBottomComponent(FileEditor var1, JComponent var2);

    public abstract void removeBottomComponent(FileEditor var1, JComponent var2);

    public abstract void addFileEditorManagerListener(FileEditorManagerListener var1);

    public abstract void addFileEditorManagerListener(FileEditorManagerListener var1, Disposable var2);

    public abstract void removeFileEditorManagerListener(FileEditorManagerListener var1);

    public abstract List<FileEditor> openEditor(OpenFileDescriptor var1, boolean var2);

    public abstract Project getProject();

    public abstract void registerExtraEditorDataProvider(EditorDataProvider var1, Disposable var2);

    public abstract Object getData(String var1, Editor var2, Caret var3);

    public abstract void setSelectedEditor(VirtualFile var1, String var2);
}

