/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExternalSystemSettings<SS extends AbstractExternalSystemSettings<SS, PS, L>, PS extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<PS>>
implements Disposable {
    private final Topic<L> myChangesTopic;
    private Project myProject;
    private final Map<String, PS> myLinkedProjectsSettings = ContainerUtilRt.newHashMap();
    private final Map<String, PS> myLinkedProjectsSettingsView = Collections.unmodifiableMap(this.myLinkedProjectsSettings);

    protected AbstractExternalSystemSettings(Topic<L> topic, Project project) {
        this.myChangesTopic = topic;
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void dispose() {
        this.myProject = null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public abstract void subscribe(ExternalSystemSettingsListener<PS> var1);

    public void copyFrom(SS settings) {
        for (ExternalProjectSettings projectSettings : ((AbstractExternalSystemSettings)settings).getLinkedProjectsSettings()) {
            this.myLinkedProjectsSettings.put(projectSettings.getExternalProjectPath(), projectSettings);
        }
        this.copyExtraSettingsFrom(settings);
    }

    protected abstract void copyExtraSettingsFrom(SS var1);

    public Collection<PS> getLinkedProjectsSettings() {
        return this.myLinkedProjectsSettingsView.values();
    }

    public PS getLinkedProjectSettings(String linkedProjectPath) {
        ExternalProjectSettings ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(linkedProjectPath);
        if (ps == null) {
            for (ExternalProjectSettings ps1 : this.myLinkedProjectsSettings.values()) {
                for (String modulePath : ps1.getModules()) {
                    if (!linkedProjectPath.equals(modulePath)) continue;
                    return (PS)ps1;
                }
            }
        }
        if (ps == null) {
            ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(FileUtil.toSystemIndependentName((String)linkedProjectPath));
        }
        return (PS)ps;
    }

    public void linkProject(PS settings) throws IllegalArgumentException {
        PS existing = this.getLinkedProjectSettings(((ExternalProjectSettings)settings).getExternalProjectPath());
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Can't link external project '%s'. Reason: it's already registered at the current ide project", ((ExternalProjectSettings)settings).getExternalProjectPath()));
        }
        this.myLinkedProjectsSettings.put(((ExternalProjectSettings)settings).getExternalProjectPath(), settings);
        this.getPublisher().onProjectsLinked(Collections.singleton(settings));
    }

    public boolean unlinkExternalProject(String linkedProjectPath) {
        ExternalProjectSettings removed = (ExternalProjectSettings)this.myLinkedProjectsSettings.remove(linkedProjectPath);
        if (removed == null) {
            return false;
        }
        this.getPublisher().onProjectsUnlinked(Collections.singleton(linkedProjectPath));
        return true;
    }

    public void setLinkedProjectsSettings(Collection<PS> settings) {
        ArrayList added = ContainerUtilRt.newArrayList();
        HashMap removed = ContainerUtilRt.newHashMap(this.myLinkedProjectsSettings);
        this.myLinkedProjectsSettings.clear();
        for (ExternalProjectSettings current : settings) {
            this.myLinkedProjectsSettings.put(current.getExternalProjectPath(), current);
        }
        for (ExternalProjectSettings current : settings) {
            ExternalProjectSettings old = (ExternalProjectSettings)removed.remove(current.getExternalProjectPath());
            if (old == null) {
                added.add(current);
                continue;
            }
            if (current.isUseAutoImport() != old.isUseAutoImport()) {
                this.getPublisher().onUseAutoImportChange(current.isUseAutoImport(), current.getExternalProjectPath());
            }
            this.checkSettings(old, current);
        }
        if (!added.isEmpty()) {
            this.getPublisher().onProjectsLinked(added);
        }
        if (!removed.isEmpty()) {
            this.getPublisher().onProjectsUnlinked(removed.keySet());
        }
    }

    protected abstract void checkSettings(PS var1, PS var2);

    public Topic<L> getChangesTopic() {
        return this.myChangesTopic;
    }

    public L getPublisher() {
        return (L)((ExternalSystemSettingsListener)this.myProject.getMessageBus().syncPublisher(this.myChangesTopic));
    }

    protected void fillState(State<PS> state) {
        state.setLinkedExternalProjectsSettings(ContainerUtilRt.newTreeSet(this.myLinkedProjectsSettings.values()));
    }

    protected void loadState(State<PS> state) {
        Set<PS> settings = state.getLinkedExternalProjectsSettings();
        if (settings != null) {
            this.myLinkedProjectsSettings.clear();
            for (ExternalProjectSettings projectSettings : settings) {
                this.myLinkedProjectsSettings.put(projectSettings.getExternalProjectPath(), projectSettings);
            }
        }
    }

    public static interface State<S> {
        public Set<S> getLinkedExternalProjectsSettings();

        public void setLinkedExternalProjectsSettings(Set<S> var1);
    }
}

