/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.execution;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;

@Tag(value="ExternalSystemSettings")
public class ExternalSystemTaskExecutionSettings
implements Cloneable {
    public static final String TAG_NAME = "ExternalSystemSettings";
    private List<String> myTaskNames = ContainerUtilRt.newArrayList();
    private List<String> myTaskDescriptions = ContainerUtilRt.newArrayList();
    private String myExecutionName;
    private String myExternalSystemIdString;
    private String myExternalProjectPath;
    private String myVmOptions;
    private String myScriptParameters;

    public String getExecutionName() {
        return this.myExecutionName;
    }

    public void setExecutionName(String executionName) {
        this.myExecutionName = executionName;
    }

    public String getExternalSystemIdString() {
        return this.myExternalSystemIdString;
    }

    public ProjectSystemId getExternalSystemId() {
        return new ProjectSystemId(this.myExternalSystemIdString);
    }

    public void setExternalSystemIdString(String externalSystemIdString) {
        this.myExternalSystemIdString = externalSystemIdString;
    }

    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    public void setExternalProjectPath(String externalProjectPath) {
        this.myExternalProjectPath = externalProjectPath;
    }

    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    public String getScriptParameters() {
        return this.myScriptParameters;
    }

    public void setScriptParameters(String scriptParameters) {
        this.myScriptParameters = scriptParameters;
    }

    public List<String> getTaskNames() {
        return this.myTaskNames;
    }

    public void setTaskNames(List<String> taskNames) {
        this.myTaskNames = taskNames;
    }

    public List<String> getTaskDescriptions() {
        return this.myTaskDescriptions;
    }

    public void setTaskDescriptions(List<String> taskDescriptions) {
        this.myTaskDescriptions = taskDescriptions;
    }

    public ExternalSystemTaskExecutionSettings clone() {
        ExternalSystemTaskExecutionSettings result = new ExternalSystemTaskExecutionSettings();
        result.setExecutionName(this.getExecutionName());
        result.setExternalSystemIdString(this.getExternalSystemIdString());
        result.setExternalProjectPath(this.getExternalProjectPath());
        result.setVmOptions(this.getVmOptions());
        result.setScriptParameters(this.getScriptParameters());
        result.setTaskNames(ContainerUtilRt.newArrayList(this.getTaskNames()));
        result.setTaskDescriptions(ContainerUtilRt.newArrayList(this.getTaskDescriptions()));
        return result;
    }

    public int hashCode() {
        int result = this.myTaskNames != null ? ((Object)this.myTaskNames).hashCode() : 0;
        result = 31 * result + (this.myExecutionName != null ? this.myExecutionName.hashCode() : 0);
        result = 31 * result + (this.myExternalSystemIdString != null ? this.myExternalSystemIdString.hashCode() : 0);
        result = 31 * result + (this.myExternalProjectPath != null ? this.myExternalProjectPath.hashCode() : 0);
        result = 31 * result + (this.myVmOptions != null ? this.myVmOptions.hashCode() : 0);
        result = 31 * result + (this.myScriptParameters != null ? this.myScriptParameters.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemTaskExecutionSettings settings = (ExternalSystemTaskExecutionSettings)o;
        if (this.myExecutionName != null ? !this.myExecutionName.equals(settings.myExecutionName) : settings.myExecutionName != null) {
            return false;
        }
        if (this.myExternalProjectPath != null ? !this.myExternalProjectPath.equals(settings.myExternalProjectPath) : settings.myExternalProjectPath != null) {
            return false;
        }
        if (this.myExternalSystemIdString != null ? !this.myExternalSystemIdString.equals(settings.myExternalSystemIdString) : settings.myExternalSystemIdString != null) {
            return false;
        }
        if (this.myTaskNames != null ? !((Object)this.myTaskNames).equals(settings.myTaskNames) : settings.myTaskNames != null) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.myVmOptions) ^ StringUtil.isEmpty((String)settings.myVmOptions)) {
            return false;
        }
        return !(StringUtil.isEmpty((String)this.myScriptParameters) ^ StringUtil.isEmpty((String)settings.myScriptParameters));
    }

    public String toString() {
        return (this.myTaskNames == null ? "" : StringUtil.join(this.myTaskNames, (String)" ")) + (StringUtil.isEmpty((String)this.myScriptParameters) ? "" : " " + this.myScriptParameters) + (StringUtil.isEmpty((String)this.myVmOptions) ? "" : " " + this.myVmOptions);
    }
}

