/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.externalSystem.model.DefaultExternalPlugin;
import com.intellij.openapi.externalSystem.model.DefaultExternalSourceSet;
import com.intellij.openapi.externalSystem.model.DefaultExternalTask;
import com.intellij.openapi.externalSystem.model.ExternalPlugin;
import com.intellij.openapi.externalSystem.model.ExternalProject;
import com.intellij.openapi.externalSystem.model.ExternalSourceSet;
import com.intellij.openapi.externalSystem.model.ExternalTask;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultExternalProject
implements ExternalProject {
    private static final long serialVersionUID = 1L;
    private String myName;
    private String myQName;
    private String myDescription;
    private String myGroup;
    private String myVersion;
    private Map<String, ExternalProject> myChildProjects = new HashMap<String, ExternalProject>();
    private File myProjectDir;
    private File myBuildDir;
    private File myBuildFile;
    private Map<String, ExternalTask> myTasks = new HashMap<String, ExternalTask>();
    private Map<String, ?> myProperties = new HashMap();
    private Map<String, ExternalSourceSet> mySourceSets = new HashMap<String, ExternalSourceSet>();
    private String myExternalSystemId;
    private Map<String, ExternalPlugin> myPlugins = new HashMap<String, ExternalPlugin>();

    public DefaultExternalProject() {
    }

    public DefaultExternalProject(ExternalProject externalProject) {
        this();
        this.myName = externalProject.getName();
        this.myQName = externalProject.getQName();
        this.myVersion = externalProject.getVersion();
        this.myGroup = externalProject.getGroup();
        this.myDescription = externalProject.getDescription();
        this.myProjectDir = externalProject.getProjectDir();
        this.myBuildDir = externalProject.getBuildDir();
        this.myBuildFile = externalProject.getBuildFile();
        this.myExternalSystemId = externalProject.getExternalSystemId();
        for (Map.Entry<String, ExternalProject> entry : externalProject.getChildProjects().entrySet()) {
            this.myChildProjects.put(entry.getKey(), new DefaultExternalProject(entry.getValue()));
        }
        for (Map.Entry<String, Serializable> entry : externalProject.getTasks().entrySet()) {
            this.myTasks.put(entry.getKey(), new DefaultExternalTask((ExternalTask)entry.getValue()));
        }
        for (Map.Entry<String, Serializable> entry : externalProject.getSourceSets().entrySet()) {
            this.mySourceSets.put(entry.getKey(), new DefaultExternalSourceSet((ExternalSourceSet)entry.getValue()));
        }
        for (Map.Entry<String, Serializable> entry : externalProject.getPlugins().entrySet()) {
            this.myPlugins.put(entry.getKey(), new DefaultExternalPlugin((ExternalPlugin)entry.getValue()));
        }
    }

    @Override
    public String getExternalSystemId() {
        return this.myExternalSystemId;
    }

    public void setExternalSystemId(String externalSystemId) {
        this.myExternalSystemId = externalSystemId;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public String getQName() {
        return this.myQName;
    }

    public void setQName(String QName) {
        this.myQName = QName;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Override
    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(String group) {
        this.myGroup = group;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String version) {
        this.myVersion = version;
    }

    @Override
    public Map<String, ExternalProject> getChildProjects() {
        return this.myChildProjects;
    }

    public void setChildProjects(Map<String, ExternalProject> childProjects) {
        this.myChildProjects = childProjects;
    }

    @Override
    public File getProjectDir() {
        return this.myProjectDir;
    }

    public void setProjectDir(File projectDir) {
        this.myProjectDir = projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.myBuildDir;
    }

    public void setBuildDir(File buildDir) {
        this.myBuildDir = buildDir;
    }

    @Override
    public File getBuildFile() {
        return this.myBuildFile;
    }

    public void setBuildFile(File buildFile) {
        this.myBuildFile = buildFile;
    }

    @Override
    public Map<String, ExternalTask> getTasks() {
        return this.myTasks;
    }

    public void setTasks(Map<String, ExternalTask> tasks) {
        this.myTasks = tasks;
    }

    @Override
    public Map<String, ExternalPlugin> getPlugins() {
        return this.myPlugins;
    }

    public void setPlugins(Map<String, ExternalPlugin> plugins) {
        this.myPlugins = plugins;
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.myProperties;
    }

    public void setProperties(Map<String, ?> properties) {
        this.myProperties = properties;
    }

    @Override
    public Object getProperty(String name) {
        return this.myProperties.get(name);
    }

    @Override
    public Map<String, ExternalSourceSet> getSourceSets() {
        return this.mySourceSets;
    }

    public void setSourceSets(Map<String, ExternalSourceSet> sourceSets) {
        this.mySourceSets = sourceSets;
    }
}

