/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.List;

public class FontPreferences {
    public static final String DEFAULT_FONT_NAME = FontPreferences.getDefaultFontName();
    public static final int DEFAULT_FONT_SIZE = FontSize.SMALL.getSize();
    private final TObjectIntHashMap<String> myFontSizes = new TObjectIntHashMap();
    private final List<String> myEffectiveFontFamilies = ContainerUtilRt.newArrayList();
    private final List<String> myRealFontFamilies = ContainerUtilRt.newArrayList();
    Runnable myChangeListener;
    private int myTemplateFontSize = DEFAULT_FONT_SIZE;

    public void setChangeListener(Runnable changeListener) {
        this.myChangeListener = changeListener;
    }

    public Runnable getChangeListener() {
        return this.myChangeListener;
    }

    public void clear() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        this.myFontSizes.clear();
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public void clearFonts() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public boolean hasSize(String fontName) {
        return this.myFontSizes.containsKey((Object)fontName);
    }

    public int getSize(String fontFamily) {
        int result = this.myFontSizes.get((Object)fontFamily);
        if (result <= 0) {
            result = this.myTemplateFontSize;
        }
        return result > 0 ? result : DEFAULT_FONT_SIZE;
    }

    public void setSize(String fontFamily, int size) {
        this.myFontSizes.put((Object)fontFamily, size);
        this.myTemplateFontSize = size;
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public List<String> getEffectiveFontFamilies() {
        return this.myEffectiveFontFamilies;
    }

    public List<String> getRealFontFamilies() {
        return this.myRealFontFamilies;
    }

    public void register(String fontFamily, int size) {
        String effectiveFontFamily;
        String fallbackFontFamily = FontPreferences.getFallbackName(fontFamily, size, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        this.setSize(fontFamily, size);
    }

    public String getFontFamily() {
        return this.myEffectiveFontFamilies.isEmpty() ? DEFAULT_FONT_NAME : this.myEffectiveFontFamilies.get(0);
    }

    public void addFontFamily(String fontFamily) {
        String effectiveFontFamily;
        String fallbackFontFamily = FontPreferences.getFallbackName(fontFamily, DEFAULT_FONT_SIZE, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public void copyTo(FontPreferences preferences) {
        preferences.myEffectiveFontFamilies.clear();
        preferences.myEffectiveFontFamilies.addAll(this.myEffectiveFontFamilies);
        preferences.myRealFontFamilies.clear();
        preferences.myRealFontFamilies.addAll(this.myRealFontFamilies);
        preferences.myFontSizes.clear();
        for (String fontFamily : this.myRealFontFamilies) {
            if (!this.myFontSizes.containsKey((Object)fontFamily)) continue;
            preferences.myFontSizes.put((Object)fontFamily, this.myFontSizes.get((Object)fontFamily));
        }
    }

    public int hashCode() {
        return ((Object)this.myRealFontFamilies).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontPreferences that = (FontPreferences)o;
        if (!((Object)this.myRealFontFamilies).equals(that.myRealFontFamilies)) {
            return false;
        }
        for (String fontFamily : this.myRealFontFamilies) {
            if (this.myFontSizes.get((Object)fontFamily) == that.myFontSizes.get((Object)fontFamily)) continue;
            return false;
        }
        return true;
    }

    private static String getDefaultFontName() {
        if (SystemInfo.isMacOSSnowLeopard) {
            return "Menlo";
        }
        if (SystemInfo.isXWindow && !GraphicsEnvironment.isHeadless()) {
            for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                if (!"DejaVu Sans Mono".equals(font.getName())) continue;
                return font.getFontName();
            }
        }
        return "Monospaced";
    }

    public static String getFallbackName(String fontName, int fontSize, EditorColorsScheme fallbackScheme) {
        Font plainFont = new Font(fontName, 0, fontSize);
        if (plainFont.getFamily().equals("Dialog") && !"Dialog".equals(fontName)) {
            return fallbackScheme == null ? DEFAULT_FONT_NAME : fallbackScheme.getEditorFontName();
        }
        return null;
    }

    public String toString() {
        return "Effective font families: " + this.myEffectiveFontFamilies;
    }
}

