/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.VisualPosition;

public class LogicalPosition
implements Comparable<LogicalPosition> {
    public final int line;
    public final int column;
    public final boolean visualPositionAware;
    public final int softWrapLinesBeforeCurrentLogicalLine;
    public final int softWrapLinesOnCurrentLogicalLine;
    public final int softWrapColumnDiff;
    public final int foldedLines;
    public final int foldingColumnDiff;

    public LogicalPosition(int line, int column) throws IllegalArgumentException {
        this(line, column, 0, 0, 0, 0, 0, false);
    }

    public LogicalPosition(int line, int column, int softWrapLinesBeforeCurrentLogicalLine, int softWrapLinesOnCurrentLogicalLine, int softWrapColumnDiff, int foldedLines, int foldingColumnDiff) throws IllegalArgumentException {
        this(line, column, softWrapLinesBeforeCurrentLogicalLine, softWrapLinesOnCurrentLogicalLine, softWrapColumnDiff, foldedLines, foldingColumnDiff, true);
    }

    private LogicalPosition(int line, int column, int softWrapLinesBeforeCurrentLogicalLine, int softWrapLinesOnCurrentLogicalLine, int softWrapColumnDiff, int foldedLines, int foldingColumnDiff, boolean visualPositionAware) throws IllegalArgumentException {
        if (column + softWrapColumnDiff + foldingColumnDiff < 0) {
            throw new IllegalArgumentException(String.format("Attempt to create %s with invalid arguments - resulting column is negative (%d). Given arguments: line=%d, column=%d, soft wrap lines before: %d, soft wrap lines current: %d, soft wrap column diff: %d, folded lines: %d, folding column diff: %d, visual position aware: %b", this.getClass().getName(), column + softWrapColumnDiff + foldingColumnDiff, line, column, softWrapLinesBeforeCurrentLogicalLine, softWrapLinesOnCurrentLogicalLine, softWrapColumnDiff, foldedLines, foldingColumnDiff, visualPositionAware));
        }
        if (line < 0) {
            throw new IllegalArgumentException("line must be non negative: " + line);
        }
        if (column < 0) {
            throw new IllegalArgumentException("column must be non negative: " + column);
        }
        this.line = line;
        this.column = column;
        this.softWrapLinesBeforeCurrentLogicalLine = softWrapLinesBeforeCurrentLogicalLine;
        this.softWrapLinesOnCurrentLogicalLine = softWrapLinesOnCurrentLogicalLine;
        this.softWrapColumnDiff = softWrapColumnDiff;
        this.foldedLines = foldedLines;
        this.foldingColumnDiff = foldingColumnDiff;
        this.visualPositionAware = visualPositionAware;
    }

    public VisualPosition toVisualPosition() {
        return new VisualPosition(this.line + this.softWrapLinesBeforeCurrentLogicalLine + this.softWrapLinesOnCurrentLogicalLine - this.foldedLines, this.column + this.softWrapColumnDiff + this.foldingColumnDiff);
    }

    public LogicalPosition withoutVisualPositionInfo() {
        return new LogicalPosition(this.line, this.column);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogicalPosition)) {
            return false;
        }
        LogicalPosition logicalPosition = (LogicalPosition)o;
        return this.column == logicalPosition.column && this.line == logicalPosition.line;
    }

    public int hashCode() {
        return 29 * this.line + this.column;
    }

    public String toString() {
        return "LogicalPosition: (" + this.line + ", " + this.column + ")" + (this.visualPositionAware ? "; vp aware" : "") + (this.softWrapLinesBeforeCurrentLogicalLine + this.softWrapLinesOnCurrentLogicalLine == 0 ? "" : "; soft wrap: lines=" + (this.softWrapLinesBeforeCurrentLogicalLine + this.softWrapLinesOnCurrentLogicalLine) + " (before=" + this.softWrapLinesBeforeCurrentLogicalLine + "; current=" + this.softWrapLinesOnCurrentLogicalLine + ")") + (this.softWrapColumnDiff == 0 ? "" : "; columns diff=" + this.softWrapColumnDiff + ";") + (this.foldedLines == 0 ? "" : "; folding: lines = " + this.foldedLines + ";") + (this.foldingColumnDiff == 0 ? "" : "; columns diff=" + this.foldingColumnDiff);
    }

    @Override
    public int compareTo(LogicalPosition position) {
        if (this.line != position.line) {
            return this.line - position.line;
        }
        if (this.column != position.column) {
            return this.column - position.column;
        }
        if (this.softWrapLinesBeforeCurrentLogicalLine != position.softWrapLinesBeforeCurrentLogicalLine) {
            return this.softWrapLinesBeforeCurrentLogicalLine - position.softWrapLinesBeforeCurrentLogicalLine;
        }
        return this.softWrapColumnDiff - position.softWrapColumnDiff;
    }
}

