/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;

public class DocumentContent
extends DiffContent {
    private final Document myDocument;
    private final VirtualFile myFile;
    private final FileType myOverriddenType;
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;

    public DocumentContent(Project project, Document document) {
        this(project, document, null);
    }

    public DocumentContent(Project project, Document document, FileType type) {
        this.myProject = project;
        this.myDocument = document;
        this.myDocumentManager = FileDocumentManager.getInstance();
        this.myFile = this.myDocumentManager.getFile(document);
        this.myOverriddenType = type;
    }

    public DocumentContent(Document document) {
        this(null, document, null);
    }

    public DocumentContent(Document document, FileType type) {
        this(null, document, type);
    }

    @Override
    public Document getDocument() {
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        if (this.myProject == null) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, file, offset);
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public FileType getContentType() {
        return this.myOverriddenType == null ? DiffContentUtil.getContentType(this.getFile()) : this.myOverriddenType;
    }

    @Override
    public byte[] getBytes() {
        return this.myDocument.getText().getBytes();
    }

    @Override
    public LineSeparator getLineSeparator() {
        return LineSeparator.fromString((String)this.myDocumentManager.getLineSeparator(this.myFile, this.myProject));
    }
}

