/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;

public abstract class StateSplitterEx
implements StateSplitter {
    @Override
    public abstract List<Pair<Element, String>> splitState(Element var1);

    public void mergeStateInto(Element target, Element subState) {
        target.addContent(subState);
    }

    @Override
    public final void mergeStatesInto(Element target, Element[] elements) {
        throw new IllegalStateException();
    }

    protected static List<Pair<Element, String>> splitState(Element state, String attributeName) {
        UniqueNameGenerator generator = new UniqueNameGenerator();
        SmartList result = new SmartList();
        for (Element subState : state.getChildren()) {
            result.add(StateSplitterEx.createItem(generator, subState, attributeName));
        }
        return result;
    }

    protected static Pair<Element, String> createItem(UniqueNameGenerator generator, Element element, String attributeName) {
        return StateSplitterEx.createItem(element.getAttributeValue(attributeName), generator, element);
    }

    protected static Pair<Element, String> createItem(String fileName, UniqueNameGenerator generator, Element element) {
        return Pair.create((Object)element, (Object)(generator.generateUniqueName(FileUtil.sanitizeFileName((String)fileName)) + ".xml"));
    }

    protected static void mergeStateInto(Element target, Element subState, String subStateName) {
        if (subState.getName().equals(subStateName)) {
            target.addContent(subState);
        } else {
            Iterator iterator = subState.getChildren().iterator();
            while (iterator.hasNext()) {
                Element configuration = (Element)iterator.next();
                iterator.remove();
                target.addContent(configuration);
            }
            iterator = subState.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                iterator.remove();
                target.setAttribute(attribute);
            }
        }
    }
}

